/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.transform;

import amf.ProfileNames;
import amf.client.AMF;
import amf.client.model.document.Module;
import amf.client.model.domain.NodeShape;
import amf.client.parse.Raml10Parser;
import amf.client.validate.ValidationReport;
import amf.client.validate.ValidationResult;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.mule.apikit.transform.exception.ODataMetadataFormatException;

public class RAMLSpecParser {
    private final String ramlPath;

    public RAMLSpecParser(String ramlPath) {
        this.ramlPath = ramlPath;
    }

    public List<NodeShape> getNodeShapes() {
        try {
            AMF.init().get();
            Raml10Parser parser = AMF.raml10Parser();
            Module module = (Module)parser.parseFileAsync(this.ramlPath).get();
            List validationResults = ((ValidationReport)parser.reportValidation(ProfileNames.RAML()).get()).results();
            if (!validationResults.isEmpty()) {
                throw new ODataMetadataFormatException(this.createErrorMessage(validationResults));
            }
            ArrayList<NodeShape> nodeShapes = new ArrayList<NodeShape>();
            module.declares().forEach(domainElement -> {
                if (domainElement instanceof NodeShape) {
                    NodeShape nodeShape = (NodeShape)domainElement;
                    nodeShapes.add(nodeShape);
                }
            });
            return nodeShapes;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ODataMetadataFormatException("AMF init failed", e);
        }
    }

    private String createErrorMessage(List<ValidationResult> validationResults) {
        StringBuilder errorMessage = new StringBuilder("Parse of odata.raml file failed: ");
        for (ValidationResult validationResult : validationResults) {
            errorMessage.append(validationResult.message());
            errorMessage.append("\n");
        }
        return errorMessage.toString();
    }
}

