/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.transform;

import amf.client.model.domain.DomainExtension;
import amf.client.model.domain.FileShape;
import amf.client.model.domain.NodeShape;
import amf.client.model.domain.PropertyShape;
import amf.client.model.domain.ScalarNode;
import amf.client.model.domain.ScalarShape;
import amf.client.model.domain.Shape;
import amf.client.model.domain.UnionShape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainer;
import org.apache.olingo.commons.api.edm.provider.CsdlEntitySet;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;
import org.apache.olingo.commons.api.edm.provider.CsdlProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlPropertyRef;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.apache.olingo.commons.core.edm.primitivetype.EdmBinary;
import org.apache.olingo.commons.core.edm.primitivetype.EdmBoolean;
import org.apache.olingo.commons.core.edm.primitivetype.EdmByte;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDate;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDateTimeOffset;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDecimal;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDouble;
import org.apache.olingo.commons.core.edm.primitivetype.EdmGuid;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt16;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt32;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt64;
import org.apache.olingo.commons.core.edm.primitivetype.EdmSingle;
import org.apache.olingo.commons.core.edm.primitivetype.EdmString;
import org.apache.olingo.commons.core.edm.primitivetype.EdmTimeOfDay;
import org.mule.apikit.transform.RAMLSpecParser;
import org.mule.apikit.transform.RamlConstants;
import org.mule.apikit.transform.exception.ODataMetadataFormatException;

public class AMFWrapper {
    private static final String AMF_STRING = "http://www.w3.org/2001/XMLSchema#string";
    private static final String AMF_BOOLEAN = "http://www.w3.org/2001/XMLSchema#boolean";
    private static final String AMF_NUMBER = "http://a.ml/vocabularies/shapes#number";
    private static final String AMF_FLOAT = "http://www.w3.org/2001/XMLSchema#float";
    private static final String AMF_DATE_TIME_ONLY = "http://a.ml/vocabularies/shapes#dateTimeOnly";
    private static final String AMF_INTEGER = "http://www.w3.org/2001/XMLSchema#integer";
    private static final String AMF_TIME = "http://www.w3.org/2001/XMLSchema#time";
    private static final String AMF_DATE_TIME = "http://www.w3.org/2001/XMLSchema#dateTime";
    private static final String AMF_DATE_ONLY = "http://www.w3.org/2001/XMLSchema#date";
    private static final String AMF_LONG = "http://www.w3.org/2001/XMLSchema#long";
    private static final Map<String, Function<ScalarShape, FullQualifiedName>> amfToEdm = AMFWrapper.amfTypeToEdm();
    private static final Map<String, FullQualifiedName> formatToEdm = AMFWrapper.formatToEdm();
    private static final String ODATA_V4_NAMESPACE = "odata.v4";
    private static final String CONTAINER_NAME = "Container";
    private List<CsdlEntityType> entityTypes = new ArrayList<CsdlEntityType>();
    private CsdlSchema schema = new CsdlSchema();

    public AMFWrapper(String ramlPath) throws ODataMetadataFormatException {
        List<NodeShape> nodeShapesList = new RAMLSpecParser(ramlPath).getNodeShapes();
        ArrayList<CsdlEntitySet> entitySets = new ArrayList<CsdlEntitySet>();
        for (NodeShape nodeShape : nodeShapesList) {
            entitySets.add(this.buildCSDLEntitySet(nodeShape));
        }
        CsdlEntityContainer entityContainer = new CsdlEntityContainer();
        entityContainer.setName(CONTAINER_NAME);
        entityContainer.setEntitySets(entitySets);
        this.schema.setEntityContainer(entityContainer);
        this.schema.setNamespace(ODATA_V4_NAMESPACE);
        this.schema.setEntityTypes(this.entityTypes);
    }

    public CsdlSchema getSchema() {
        return this.schema;
    }

    private CsdlEntitySet buildCSDLEntitySet(NodeShape nodeShape) throws ODataMetadataFormatException {
        if (nodeShape.properties().isEmpty()) {
            throw new ODataMetadataFormatException("No schemas found.");
        }
        CsdlEntitySet entitySet = new CsdlEntitySet();
        String entityName = AMFWrapper.getAnnotation((Shape)nodeShape, RamlConstants.NAMESPACE_REMOTE_NAME).orElse(nodeShape.name().value());
        entitySet.setName(entityName);
        CsdlEntityType entityType = this.buildEntityType(nodeShape);
        this.entityTypes.add(entityType);
        entitySet.setType(new FullQualifiedName(ODATA_V4_NAMESPACE, entityType.getName()));
        return entitySet;
    }

    private CsdlEntityType buildEntityType(NodeShape nodeShape) throws ODataMetadataFormatException {
        if (nodeShape.properties().isEmpty()) {
            throw new ODataMetadataFormatException("No schemas found.");
        }
        CsdlEntityType entityType = new CsdlEntityType();
        String entityName = AMFWrapper.getAnnotation((Shape)nodeShape, RamlConstants.NAMESPACE_ENTITY_TYPE_NAME).orElse(nodeShape.name().value());
        entityType.setName(entityName);
        ArrayList<CsdlProperty> csdlProperties = new ArrayList<CsdlProperty>();
        ArrayList<CsdlPropertyRef> csdlKeys = new ArrayList<CsdlPropertyRef>();
        for (PropertyShape propertyShape : nodeShape.properties()) {
            CsdlProperty entityProperty = new CsdlProperty();
            String propertyName = propertyShape.name().value();
            entityProperty.setName(propertyName);
            Shape shape = this.getScalarShape(propertyShape.range());
            String key = AMFWrapper.getAnnotation(shape, RamlConstants.NAMESPACE_KEY_PROPERTY).orElse(null);
            boolean isKey = Boolean.valueOf(key);
            if (isKey) {
                CsdlPropertyRef propertyRef = new CsdlPropertyRef();
                propertyRef.setName(propertyName);
                csdlKeys.add(propertyRef);
            }
            String nullable = AMFWrapper.getAnnotation(shape, RamlConstants.NAMESPACE_NULLABLE_PROPERTY).orElseThrow(() -> new ODataMetadataFormatException(String.format("(odata.nullable) is missing in field : %s, for entity : %s", propertyName, entityName)));
            boolean isNullable = Boolean.valueOf(nullable);
            entityProperty.setNullable(isNullable);
            String defaultValue = propertyShape.defaultValue() != null ? propertyShape.defaultValue().name().value() : null;
            entityProperty.setDefaultValue(defaultValue);
            if (shape instanceof ScalarShape) {
                ScalarShape scalarShape = (ScalarShape)shape;
                String type = this.getODataType(scalarShape);
                String maxLength = null;
                if (EdmString.getInstance().getFullQualifiedName().toString().equals(type)) {
                    Integer maxLengthInt = scalarShape.maxLength().value();
                    maxLength = maxLengthInt != 0 ? String.valueOf(maxLengthInt) : null;
                    String unicode = AMFWrapper.getAnnotation(shape, RamlConstants.NAMESPACE_UNICODE_PROPERTY).orElse(null);
                    boolean isUnicode = Boolean.valueOf(unicode);
                    entityProperty.setUnicode(isUnicode);
                }
                String precision = AMFWrapper.getAnnotation((Shape)scalarShape, RamlConstants.NAMESPACE_PRECISION_PROPERTY).orElse(null);
                String scale = AMFWrapper.getAnnotation((Shape)scalarShape, RamlConstants.NAMESPACE_SCALE_PROPERTY).orElse(null);
                if (maxLength != null) {
                    entityProperty.setMaxLength(Integer.valueOf(maxLength));
                }
                if (precision != null) {
                    entityProperty.setPrecision(Integer.valueOf(precision));
                }
                if (scale != null) {
                    entityProperty.setScale(Integer.valueOf(scale));
                }
                entityProperty.setType(type);
            } else if (shape instanceof FileShape) {
                entityProperty.setType(EdmBinary.getInstance().getFullQualifiedName().toString());
            } else {
                throw new ODataMetadataFormatException("Type not supported of property " + propertyName);
            }
            csdlProperties.add(entityProperty);
        }
        entityType.setProperties(csdlProperties);
        if (csdlKeys.isEmpty()) {
            throw new ODataMetadataFormatException("Entity must have a primary key.");
        }
        entityType.setKey(csdlKeys);
        return entityType;
    }

    private String getODataType(ScalarShape scalarShape) {
        String dataType = scalarShape.dataType().value();
        FullQualifiedName name = Optional.ofNullable(amfToEdm.get(dataType).apply(scalarShape)).orElseThrow(() -> new ODataMetadataFormatException(String.format("Type not supported %s of property %s", dataType, scalarShape.name())));
        return name.toString();
    }

    private Shape getScalarShape(Shape shape) {
        if (!(shape instanceof UnionShape)) {
            return shape;
        }
        UnionShape unionShape = (UnionShape)shape;
        List annotations = shape.customDomainProperties();
        for (Shape unionSubShape : unionShape.anyOf()) {
            if (!(unionSubShape instanceof ScalarShape)) continue;
            unionSubShape.withCustomDomainProperties(annotations);
            return unionSubShape;
        }
        throw new ODataMetadataFormatException(String.format("Property %s cannot be just null.", shape.name()));
    }

    private static FullQualifiedName getNumberType(ScalarShape scalarShape) {
        String format = scalarShape.format().value();
        if (format != null) {
            return Optional.ofNullable(formatToEdm.get(format)).orElseThrow(() -> new ODataMetadataFormatException(String.format("Unexpected format %s for number type.", format)));
        }
        if (AMF_INTEGER.equals(scalarShape.dataType().value())) {
            return EdmInt32.getInstance().getFullQualifiedName();
        }
        String scale = AMFWrapper.getAnnotation((Shape)scalarShape, RamlConstants.NAMESPACE_SCALE_PROPERTY).orElse(null);
        String precision = AMFWrapper.getAnnotation((Shape)scalarShape, RamlConstants.NAMESPACE_PRECISION_PROPERTY).orElse(null);
        return scale != null && precision != null ? EdmDecimal.getInstance().getFullQualifiedName() : EdmDouble.getInstance().getFullQualifiedName();
    }

    private static FullQualifiedName getStringType(ScalarShape scalarShape) {
        String subType = AMFWrapper.getAnnotation((Shape)scalarShape, RamlConstants.NAMESPACE_TYPE_PROPERTY).orElse(null);
        return "guid".equals(subType) ? EdmGuid.getInstance().getFullQualifiedName() : EdmString.getInstance().getFullQualifiedName();
    }

    private static Optional<String> getAnnotation(Shape nodeShape, String annotationName) {
        Optional<DomainExtension> annotation = nodeShape.customDomainProperties().stream().filter(domainExtension -> annotationName.equals(domainExtension.name().value())).findFirst();
        return annotation.map(domainExtension -> ((ScalarNode)domainExtension.extension()).value().value());
    }

    private static Map<String, Function<ScalarShape, FullQualifiedName>> amfTypeToEdm() {
        HashMap<String, Function<ScalarShape, FullQualifiedName>> amfToEdm = new HashMap<String, Function<ScalarShape, FullQualifiedName>>();
        amfToEdm.put(AMF_BOOLEAN, shape -> EdmBoolean.getInstance().getFullQualifiedName());
        amfToEdm.put(AMF_STRING, AMFWrapper::getStringType);
        amfToEdm.put(AMF_FLOAT, shape -> EdmSingle.getInstance().getFullQualifiedName());
        amfToEdm.put(AMF_DATE_TIME_ONLY, shape -> EdmDateTimeOffset.getInstance().getFullQualifiedName());
        amfToEdm.put(AMF_DATE_TIME, shape -> EdmDateTimeOffset.getInstance().getFullQualifiedName());
        amfToEdm.put(AMF_NUMBER, AMFWrapper::getNumberType);
        amfToEdm.put(AMF_INTEGER, AMFWrapper::getNumberType);
        amfToEdm.put(AMF_LONG, AMFWrapper::getNumberType);
        amfToEdm.put(AMF_TIME, shape -> EdmTimeOfDay.getInstance().getFullQualifiedName());
        amfToEdm.put(AMF_DATE_ONLY, shape -> EdmDate.getInstance().getFullQualifiedName());
        return amfToEdm;
    }

    private static Map<String, FullQualifiedName> formatToEdm() {
        HashMap<String, FullQualifiedName> formatToEdm = new HashMap<String, FullQualifiedName>();
        formatToEdm.put("int64", EdmInt64.getInstance().getFullQualifiedName());
        formatToEdm.put("int32", EdmInt32.getInstance().getFullQualifiedName());
        formatToEdm.put("int16", EdmInt16.getInstance().getFullQualifiedName());
        formatToEdm.put("int8", EdmByte.getInstance().getFullQualifiedName());
        return formatToEdm;
    }
}

