/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.odata.utils;

import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.mule.apikit.model.MuleXml;
import org.mule.apikit.xml.XmlHandler;

public class ODataXmlHandler
extends XmlHandler {
    public ODataXmlHandler(Map<String, InputStream> muleXml) {
        super(muleXml);
    }

    @Override
    public Map<String, InputStream> appendDiff(List<MuleXml> diff) {
        HashMap<String, InputStream> result = new HashMap<String, InputStream>();
        diff.forEach(file -> {
            Element mule = this.inputFiles.get(file.getName()) == null ? this.createMuleXml() : ((Document)this.inputFiles.get(file.getName())).getRootElement();
            file.getConfigurations().forEach(configuration -> configuration.transformToXml(mule));
            file.getFlows().forEach(flow -> flow.transformToXml(mule));
            result.put(file.getName(), this.muleElementToInputStream(mule));
        });
        return result;
    }

    @Override
    protected Map<String, Namespace> getNamespaces() {
        return ImmutableMap.of((Object)"http://www.mulesoft.org/schema/mule/core/current/mule.xsd", (Object)Namespace.getNamespace((String)"http://www.mulesoft.org/schema/mule/core"), (Object)"http://www.mulesoft.org/schema/mule/apikit-odata/current/mule-apikit-odata.xsd", (Object)Namespace.getNamespace((String)"apikit-odata", (String)"http://www.mulesoft.org/schema/mule/apikit-odata"), (Object)"http://www.mulesoft.org/schema/mule/http/current/mule-http.xsd", (Object)Namespace.getNamespace((String)"http", (String)"http://www.mulesoft.org/schema/mule/http"), (Object)"http://www.mulesoft.org/schema/mule/ee/core/current/mule-ee.xsd", (Object)Namespace.getNamespace((String)"ee", (String)"http://www.mulesoft.org/schema/mule/ee/core"));
    }
}

