/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.odata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ServiceMetadata;
import org.mule.apikit.ModelMapper;
import org.mule.apikit.model.Configuration;
import org.mule.apikit.model.ErrorHandler;
import org.mule.apikit.model.Logger;
import org.mule.apikit.model.MuleXml;
import org.mule.apikit.model.OnErrorPropagateFlow;
import org.mule.apikit.model.SetPayloadEE;
import org.mule.apikit.model.SetVariableEE;
import org.mule.apikit.model.Transform;
import org.mule.apikit.odata.model.EntityCollectionListener;
import org.mule.apikit.odata.model.EntityListener;
import org.mule.apikit.odata.model.ListenerConfig;
import org.mule.apikit.odata.model.ListenerOperation;
import org.mule.apikit.odata.model.ODataConfig;
import org.mule.apikit.odata.model.ODataFlow;
import org.mule.apikit.odata.model.RouteOperation;
import org.mule.apikit.odata.model.SerializeEntityCollectionOperation;
import org.mule.apikit.odata.model.SerializeEntityOperation;
import org.mule.apikit.odata.utils.CsdlEdmProvider;
import org.mule.apikit.xml.MuleElement;

public class ODataModelMapper
implements ModelMapper {
    private static final Set<String> methods = ImmutableSet.of((Object)"GET", (Object)"POST", (Object)"PATCH", (Object)"PUT", (Object)"DELETE");

    @Override
    public List<MuleXml> getModel(File api, Map<String, String> customConfigs) {
        try {
            ServiceMetadata serviceMetadata = OData.newInstance().createServiceMetadata((org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider)new CsdlEdmProvider(new FileInputStream(api)), new ArrayList());
            Edm edm = serviceMetadata.getEdm();
            List entitySets = edm.getEntityContainer().getEntitySets();
            String fileName = api.getName().substring(0, api.getName().indexOf("."));
            MuleXml muleXml = new MuleXml(String.format("%s.xml", fileName));
            ODataConfig configuration = new ODataConfig(String.format("%s-config", fileName), "api/" + api.getName());
            muleXml.addConfiguration(configuration);
            ListenerConfig listenerConfiguration = new ListenerConfig("HTTP_Listener_Config");
            muleXml.addConfiguration(listenerConfiguration);
            muleXml.addFlow(this.createMainFlow(configuration, listenerConfiguration));
            entitySets.forEach(entitySet -> {
                List<ODataFlow> flowsForEntitySet = this.getFlowsForEntitySet((EdmEntitySet)entitySet, configuration);
                flowsForEntitySet.forEach(muleXml::addFlow);
            });
            return ImmutableList.of((Object)muleXml);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("API File Not Found", e);
        }
    }

    private List<ODataFlow> getFlowsForEntitySet(EdmEntitySet entitySet, Configuration configuration) {
        ArrayList<ODataFlow> result = new ArrayList<ODataFlow>();
        methods.forEach(method -> {
            String flowName = String.format("%s\\%s\\%s", method, entitySet.getName(), "ENTITY");
            ODataFlow oDataFlow = new ODataFlow(flowName);
            String path = String.format("/%s", entitySet.getName());
            EntityListener entityListener = new EntityListener(configuration);
            entityListener.setParameter("method", (String)method);
            entityListener.setParameter("path", path);
            oDataFlow.addMuleElement(entityListener);
            Logger logger = new Logger(String.format("In %s flow", flowName));
            oDataFlow.addMuleElement(logger);
            if (!"DELETE".equals(method)) {
                SerializeEntityOperation serializeEntityOperation = new SerializeEntityOperation(configuration);
                serializeEntityOperation.setParameter("method", (String)method);
                serializeEntityOperation.setParameter("path", path);
                oDataFlow.addMuleElement(serializeEntityOperation);
            }
            result.add(oDataFlow);
        });
        String flowName = String.format("%s\\%s\\%s", "GET", entitySet.getName(), "ENTITY_COLLECTION");
        ODataFlow oDataFlow = new ODataFlow(flowName);
        String path = String.format("/%s", entitySet.getName());
        EntityCollectionListener entityCollectionListener = new EntityCollectionListener(configuration);
        entityCollectionListener.setParameter("method", "GET");
        entityCollectionListener.setParameter("path", path);
        Logger logger = new Logger(String.format("In %s flow", flowName));
        SerializeEntityCollectionOperation serializeEntityCollectionOperation = new SerializeEntityCollectionOperation(configuration);
        serializeEntityCollectionOperation.setParameter("method", "GET");
        serializeEntityCollectionOperation.setParameter("path", path);
        oDataFlow.addMuleElement(entityCollectionListener);
        oDataFlow.addMuleElement(logger);
        oDataFlow.addMuleElement(serializeEntityCollectionOperation);
        result.add(oDataFlow);
        return result;
    }

    private ODataFlow createMainFlow(Configuration configuration, Configuration listenerConfiguration) {
        ODataFlow mainFlow = new ODataFlow("main-odata-flow");
        ListenerOperation listenerOperation = new ListenerOperation(listenerConfiguration);
        mainFlow.addMuleElement(listenerOperation);
        mainFlow.addMuleElement(this.getRouteOperation(configuration));
        mainFlow.addMuleElement(this.getErrorHandler());
        return mainFlow;
    }

    private MuleElement getRouteOperation(Configuration configuration) {
        RouteOperation routeOperation = new RouteOperation(configuration);
        routeOperation.setParameter("method", "#[attributes.method]");
        routeOperation.setParameter("maskedRequestPath", "#[attributes.maskedRequestPath]");
        routeOperation.setParameter("scheme", "#[upper(attributes.scheme)]");
        routeOperation.setParameter("host", "#[attributes.headers.'host']");
        routeOperation.setParameter("listenerPath", "#[attributes.listenerPath]");
        routeOperation.setParameter("httpHeaders", "#[attributes.headers]");
        routeOperation.setParameter("queryString", "#[(attributes.rawRequestUri scan /(?<=^[^#?]*\\?)[^#]*/)[0][0] default '']");
        return routeOperation;
    }

    private MuleElement getErrorHandler() {
        OnErrorPropagateFlow onErrorPropagateFlow = new OnErrorPropagateFlow("On_Error_Propagate", true, true, "MULE:ANY");
        SetPayloadEE setPayload = new SetPayloadEE("%dw 2.0\noutput application/json\n---\n{\n\terror: {\n\t\tcode: error.errorMessage.payload.code default \"UNKNOWN\",\n\t\tmessage: error.errorMessage.payload.message default error.description,\n\t\ttarget: error.errorMessage.payload.target,\n\t\tdetails: error.errorMessage.payload.details default [{code: \"UNKNOWN\", message: error.detailedDescription, target: null}],\n\t\tinnererror: error.errorMessage.payload.innerError default error.childErrors\n\t}\n}");
        SetVariableEE setVariable = new SetVariableEE("statusCode", "error.errorMessage.payload.statusCode default 500");
        Transform transform = new Transform(setPayload, null, Arrays.asList(setVariable));
        onErrorPropagateFlow.addMuleElement(transform);
        ErrorHandler errorHandler = new ErrorHandler("Error_Handler");
        errorHandler.addOnErrorFlow(onErrorPropagateFlow);
        return errorHandler;
    }
}

