/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.mule.apikit.model.Configuration;
import org.mule.apikit.model.Flow;
import org.mule.apikit.model.MuleXml;

public class MuleApp {
    private final Map<String, Document> muleXmls;
    private final Map<String, MuleXml> diffs = new HashMap<String, MuleXml>();

    public MuleApp(Map<String, Document> existingXmls) {
        this.muleXmls = existingXmls;
    }

    public List<MuleXml> getXmls() {
        return new ArrayList<MuleXml>(this.diffs.values());
    }

    public void addConfig(String fileName, Configuration configuration) {
        if (this.diffs.get(fileName) == null) {
            this.diffs.put(fileName, new MuleXml(fileName));
        }
        this.diffs.get(fileName).addConfiguration(configuration);
    }

    public void addFlow(String fileName, Flow flow) {
        if (this.diffs.get(fileName) == null) {
            this.diffs.put(fileName, new MuleXml(fileName));
        }
        this.diffs.get(fileName).addFlow(flow);
    }

    public boolean containsConfig(Configuration configuration) {
        for (Map.Entry<String, Document> entry : this.muleXmls.entrySet()) {
            if (!configuration.exists(entry.getValue())) continue;
            return true;
        }
        return false;
    }

    public boolean containsFlow(Flow flow) {
        for (Map.Entry<String, Document> entry : this.muleXmls.entrySet()) {
            if (!flow.exists(entry.getValue())) continue;
            return true;
        }
        return false;
    }
}

