/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.internal;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.apikit.ModelMapper;
import org.mule.apikit.Scaffolder;
import org.mule.apikit.ScaffoldingConfig;
import org.mule.apikit.ScaffoldingResult;
import org.mule.apikit.ScaffoldingResultImpl;
import org.mule.apikit.model.Configuration;
import org.mule.apikit.model.Flow;
import org.mule.apikit.model.MuleApp;
import org.mule.apikit.model.MuleXml;

public class ODataScaffolder
implements Scaffolder {
    protected final ModelMapper apiSpecToModel;

    public ODataScaffolder(ModelMapper apiSpecToModel) {
        this.apiSpecToModel = apiSpecToModel;
    }

    @Override
    public ScaffoldingResult scaffold(ScaffoldingConfig scaffoldingConfig) {
        MuleApp muleApp = new MuleApp(scaffoldingConfig.existingXmls());
        List<MuleXml> listOfFiles = this.apiSpecToModel.getModel(scaffoldingConfig.api(), scaffoldingConfig.customConfigs());
        listOfFiles.forEach(file -> {
            file.getConfigurations().forEach(config -> {
                if (!muleApp.containsConfig((Configuration)config)) {
                    muleApp.addConfig(file.getName(), (Configuration)config);
                }
            });
            file.getFlows().forEach(flow -> {
                if (!muleApp.containsFlow((Flow)flow)) {
                    muleApp.addFlow(file.getName(), (Flow)flow);
                }
            });
        });
        Map<String, InputStream> result = scaffoldingConfig.getXmlHandler().appendDiff(muleApp.getXmls());
        return new ScaffoldingResultImpl(true, result, Collections.emptyList());
    }
}

