/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.transform;


import static java.lang.String.format;

public class RamlConstants {

  public static final String NAMESPACE = "odata";

  public static final String REMOTE_NAME = "remote";
  public static final String TYPE_PROPERTY = "type";
  public static final String NULLABLE_PROPERTY = "nullable";
  public static final String UNICODE_PROPERTY = "unicode";
  public static final String KEY_PROPERTY = "key";
  public static final String PRECISION_PROPERTY = "precision";
  public static final String SCALE_PROPERTY = "scale";
  public static final String ENTITY_TYPE = "entityType";

  public static final String NAMESPACE_ENTITY_TYPE_NAME = format("%s.%s", NAMESPACE, ENTITY_TYPE);
  public static final String NAMESPACE_REMOTE_NAME = format("%s.%s", NAMESPACE, REMOTE_NAME);
  public static final String NAMESPACE_NULLABLE_PROPERTY = format("%s.%s", NAMESPACE, NULLABLE_PROPERTY);
  public static final String NAMESPACE_UNICODE_PROPERTY = format("%s.%s", NAMESPACE, UNICODE_PROPERTY);
  public static final String NAMESPACE_KEY_PROPERTY = format("%s.%s", NAMESPACE, KEY_PROPERTY);
  public static final String NAMESPACE_PRECISION_PROPERTY = format("%s.%s", NAMESPACE, PRECISION_PROPERTY);
  public static final String NAMESPACE_SCALE_PROPERTY = format("%s.%s", NAMESPACE, SCALE_PROPERTY);
  public static final String NAMESPACE_TYPE_PROPERTY = format("%s.%s", NAMESPACE, TYPE_PROPERTY);

  public static final String INT64 = "int64";
  public static final String INT32 = "int32";
  public static final String INT16 = "int16";
  public static final String INT8 = "int8";

  public static final String GUID = "guid";

}
