/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.odata.utils;

import org.jdom2.Element;
import org.jdom2.Namespace;
import org.mule.apikit.model.MuleXml;
import org.mule.apikit.xml.XmlHandler;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.google.common.collect.ImmutableMap.of;

public class ODataXmlHandler extends XmlHandler {

  public ODataXmlHandler(Map<String, InputStream> muleXml) {
    super(muleXml);
  }

  @Override
  public Map<String, InputStream> appendDiff(List<MuleXml> diff) {
    Map<String, InputStream> result = new HashMap<>();

    diff.forEach(file -> {

      Element mule = inputFiles.get(file.getName()) == null ? createMuleXml() : inputFiles.get(file.getName()).getRootElement();

      file.getConfigurations().forEach(configuration -> configuration.transformToXml(mule));

      file.getFlows().forEach(flow -> flow.transformToXml(mule));

      result.put(file.getName(), muleElementToInputStream(mule));
    });
    return result;
  }

  @Override
  protected Map<String, Namespace> getNamespaces() {
    return of(
              "http://www.mulesoft.org/schema/mule/core/current/mule.xsd",
              Namespace.getNamespace("http://www.mulesoft.org/schema/mule/core"),
              "http://www.mulesoft.org/schema/mule/apikit-odata/current/mule-apikit-odata.xsd",
              Namespace.getNamespace("apikit-odata", "http://www.mulesoft.org/schema/mule/apikit-odata"),
              "http://www.mulesoft.org/schema/mule/http/current/mule-http.xsd",
              Namespace.getNamespace("http", "http://www.mulesoft.org/schema/mule/http"),
              "http://www.mulesoft.org/schema/mule/ee/core/current/mule-ee.xsd",
              Namespace.getNamespace("ee", "http://www.mulesoft.org/schema/mule/ee/core"));
  }
}
