/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.odata.model;

import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.mule.apikit.model.Configuration;
import org.mule.apikit.model.Processor;

public class RouteOperation extends Processor {

  private static final Namespace odataNamespace = Namespace
      .getNamespace("apikit-odata", "http://www.mulesoft.org/schema/mule/apikit-odata");

  private static final XPathExpression<Element> routeExpression = XPathFactory
      .instance().compile("//*/*[local-name()='route']", Filters.element(odataNamespace));

  public RouteOperation(Configuration configuration) {
    super("route", configuration);
  }

  @Override
  public void transformToXml(Element element) {
    Element routeOperation = new Element(name, odataNamespace);
    routeOperation.setAttribute("config-ref", configuration.getName());
    Element parameters = new Element("http-request-parameters", odataNamespace);
    this.parameters.entrySet()
        .forEach(entry -> parameters.setAttribute(entry.getKey(), entry.getValue()));
    routeOperation.addContent(parameters);
    element.addContent(routeOperation);
  }

  @Override
  public boolean exists(Document document) {
    List<Element> elementList = routeExpression.evaluate(document);
    for (Element element : elementList) {
      Attribute configRef = element.getAttribute("config-ref");
      if (getConfiguration().getName().equals(configRef.getValue())) {
        return true;
      }
    }
    return false;
  }
}
