/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.odata.model;

import static org.jdom2.xpath.XPathFactory.instance;

import java.util.List;
import java.util.Objects;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.mule.apikit.model.Configuration;
import org.mule.apikit.xml.MuleElement;

public class ODataConfig extends Configuration implements MuleElement {

  private static final Namespace odataNamespace = Namespace
      .getNamespace("apikit-odata", "http://www.mulesoft.org/schema/mule/apikit-odata");

  private static final XPathExpression<Element> configExpression =
      instance().compile("//*/*[local-name()='config']", Filters.element(odataNamespace));

  private String api;

  public ODataConfig(String name, String api) {
    super(name);
    this.api = api;
  }

  @Override
  public void transformToXml(Element element) {
    Element result = new Element("config", odataNamespace);
    result.setAttribute("name", name);
    result.setAttribute("apiDefinition", api);
    element.addContent(result);
  }

  @Override
  public boolean exists(Document document) {
    List<Element> elementList = configExpression.evaluate(document);
    for (Element element : elementList) {
      Attribute name = element.getAttribute("name");
      if (getName().equals(name.getValue())) {
        return true;
      }
    }
    return false;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ODataConfig)) {
      return false;
    }
    ODataConfig that = (ODataConfig) o;
    return Objects.equals(api, that.api) && Objects.equals(name, that.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(api);
  }
}
