/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.odata.model;

import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.mule.apikit.model.Configuration;
import org.mule.apikit.model.Processor;

public class ListenerOperation extends Processor {


  private static final Namespace listenerNamespace = Namespace
      .getNamespace("http", "http://www.mulesoft.org/schema/mule/http");

  public ListenerOperation(Configuration listenerConfiguration) {
    super("listener", listenerConfiguration);
  }

  @Override
  public void transformToXml(Element element) {
    Element listener = new Element(name, listenerNamespace);
    listener.setAttribute("config-ref", configuration.getName());
    listener.setAttribute("path", "/api/*");

    Element response = new Element("response", listenerNamespace);
    response.setAttribute("statusCode", "#[attributes.statusCode default 200]");

    Element responseHeaders = new Element("headers", listenerNamespace);
    responseHeaders.addContent("#[attributes.headers default {}]");

    response.addContent(responseHeaders);
    listener.addContent(response);

    Element errorResponse = new Element("error-response", listenerNamespace);
    errorResponse.setAttribute("statusCode", "#[vars.statusCode default 500]");

    Element errorBody = new Element("body", listenerNamespace);
    errorBody.addContent("#[payload]");

    Element errorHeaders = new Element("headers", listenerNamespace);
    errorHeaders.addContent("#[vars.headers default {}]");

    errorResponse.addContent(errorBody);
    errorResponse.addContent(errorHeaders);
    listener.addContent(errorResponse);

    element.addContent(listener);
  }

  @Override
  public boolean exists(Document document) {
    return false;
  }
}
