/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.odata.model;

import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.mule.apikit.model.Configuration;
import org.mule.apikit.xml.MuleElement;

import java.util.List;

import static org.jdom2.xpath.XPathFactory.instance;

public class ListenerConfig extends Configuration implements MuleElement {

  private static final Namespace listenerNamespace = Namespace
      .getNamespace("http", "http://www.mulesoft.org/schema/mule/http");

  private static final XPathExpression<Element> configExpression =
      instance().compile("//*/*[local-name()='listener-config']", Filters.element(listenerNamespace));

  public ListenerConfig(String name) {
    super(name);
  }

  @Override
  public void transformToXml(Element element) {

    Element listener = new Element("listener-config", listenerNamespace);
    listener.setAttribute("name", name);
    Element connection = new Element("listener-connection", listenerNamespace);
    connection.setAttribute("host", "0.0.0.0");
    connection.setAttribute("port", "8081");
    listener.addContent(connection);
    element.addContent(listener);
  }

  @Override
  public boolean exists(Document document) {
    List<Element> elementList = configExpression.evaluate(document);
    for (Element element : elementList) {
      Attribute name = element.getAttribute("name");
      if (getName().equals(name.getValue())) {
        return true;
      }
    }
    return false;
  }
}
