/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.model;

import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.mule.apikit.xml.MuleElement;

import java.util.List;

public class Transform implements MuleElement {

  private static final Namespace eeNamespace = Namespace
      .getNamespace("ee", "http://www.mulesoft.org/schema/mule/ee/core");

  private SetPayloadEE setPayload;
  private SetAttributesEE setAttributes;
  private List<SetVariableEE> setVariableList;

  public Transform(SetPayloadEE setPayload, SetAttributesEE setAttributes,
                   List<SetVariableEE> setVariableList) {
    this.setPayload = setPayload;
    this.setAttributes = setAttributes;
    this.setVariableList = setVariableList;
  }

  @Override
  public void transformToXml(Element element) {
    Element transform = new Element("transform", eeNamespace);
    Element message = new Element("message", eeNamespace);
    if (setPayload != null) {
      setPayload.transformToXml(message);
    }
    if (setAttributes != null) {
      setAttributes.transformToXml(message);
    }
    transform.addContent(message);
    Element variables = new Element("variables", eeNamespace);
    if (setVariableList != null && !setVariableList.isEmpty()) {
      setVariableList.forEach(setVariable -> setVariable.transformToXml(variables));
    }
    transform.addContent(variables);
    element.addContent(transform);
  }

  @Override
  public boolean exists(Document document) {
    return false;
  }

}
