/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.model;

import org.jdom2.Element;

public class SetVariable extends TypedValueElement {

  private final String variableName;

  public SetVariable(String variableName, String value, String mimeType, String encoding) {
    super(value, mimeType, encoding);
    this.variableName = variableName;
  }

  @Override
  protected String getElementName() {
    return "set-variable";
  }

  @Override
  protected void enrichTypedValueElement(Element typedValueElement) {
    typedValueElement.setAttribute("variableName", variableName);
  }

}
