/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.model;

import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public abstract class OnErrorFlow extends Flow {

  private static final Namespace muleCoreNamespace = Namespace
      .getNamespace("http://www.mulesoft.org/schema/mule/core");

  protected final boolean enableNotifications;
  protected final boolean logException;
  protected final String type;

  public OnErrorFlow(String name, boolean enableNotifications, boolean logException, String type) {
    super(name);
    this.enableNotifications = enableNotifications;
    this.logException = logException;
    this.type = type;
  }

  @Override
  public void transformToXml(Element element) {
    Element onErrorPropagate = new Element(getElementName(), muleCoreNamespace);
    onErrorPropagate.setAttribute("name", name);
    onErrorPropagate.setAttribute("enableNotifications", Boolean.toString(enableNotifications));
    onErrorPropagate.setAttribute("logException", Boolean.toString(logException));
    onErrorPropagate.setAttribute("type", type);
    muleElements.forEach(muleElement -> muleElement.transformToXml(onErrorPropagate));
    element.addContent(onErrorPropagate);
  }

  @Override
  public boolean exists(Document document) {
    return false;
  }

  /**
   * Get XML Element tag name.
   *
   * @return tag name
   */
  protected abstract String getElementName();
}
