/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.model;

import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.mule.apikit.xml.MuleElement;

public class Logger implements MuleElement {

  private static final Namespace muleCoreNamespace = Namespace
      .getNamespace("http://www.mulesoft.org/schema/mule/core");
  private final String message;

  public Logger(String message) {
    this.message = message;
  }

  @Override
  public void transformToXml(Element element) {
    Element logger = new Element("logger", muleCoreNamespace);
    logger.setAttribute("level", "INFO");
    logger.setAttribute("message", message);
    element.addContent(logger);
  }

  @Override
  public boolean exists(Document document) {
    return false;
  }
}
