/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit;

import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class ScaffoldingResultImpl implements ScaffoldingResult {

  private final boolean success;

  private final Map<String, InputStream> xmls;

  private final List<ScaffoldingError> errors;

  public ScaffoldingResultImpl(boolean success, Map<String, InputStream> xmls, List<ScaffoldingError> errors) {
    this.success = success;
    this.xmls = xmls;
    this.errors = errors;
  }

  @Override
  public boolean success() {
    return success;
  }

  @Override
  public Map<String, InputStream> generatedMuleXmls() {
    return xmls;
  }

  @Override
  public List<ScaffoldingError> errors() {
    return errors;
  }
}
