%dw 2.0
import validateAPICanBeScaffolded from scripts::asyncapi::validations::AsyncAPIValidations
import * from scripts::asyncapi::AsyncApiModule
import fail from dw::Runtime
import getSchemaLocations from scripts::asyncapi::protocol::ProtocolAdapterModule

input api application/json
input existingConfiguration application/xml
output application/xml defaultNamespace="http://www.mulesoft.org/schema/mule/core", inlineCloseOn="null"

var protocols = getProtocols(api)
var schemas = [getAsyncApiSchemaLocation()] ++ getSchemaLocations(protocols)
var publishOps = getPublishOpTypes(api)
var subscribeOps = getSubscribeOpTypes(api)
var servers = getServers(api)

---
mule @((getMuleNamespacesByProtocolSchemas(schemas))): {
    (
        if (!validateAPICanBeScaffolded(api, publishOps, subscribeOps))
            fail("The AsyncAPI contains not supported scenarios")
        else
            publishOps map ((publishOp, index) ->
                scaffoldAsyncApiSubscribeFlow(api, existingConfiguration, servers, publishOp)
            )
    )
}
