/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apikit.scaffolding.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import org.mule.apikit.scaffolding.api.ScaffoldingError;

public class ScaffoldingErrorImpl
implements ScaffoldingError {
    private final String message;
    private final Throwable cause;
    private final String stackTrace;
    private final String header;

    public ScaffoldingErrorImpl(String message) {
        this(null, message, null);
    }

    public ScaffoldingErrorImpl(Throwable cause) {
        this(cause, null, null);
    }

    public ScaffoldingErrorImpl(Throwable cause, String message) {
        this(cause, message, null);
    }

    public ScaffoldingErrorImpl(Throwable cause, String message, String header) {
        this.cause = cause;
        this.message = message;
        this.stackTrace = this.getStackTraceAsString(cause);
        this.header = header;
    }

    @Override
    public String cause() {
        String errorMessage = this.message != null ? this.message : Optional.ofNullable(this.cause).map(Throwable::getMessage).orElse("An error occurred while scaffolding");
        return errorMessage.endsWith(".") ? errorMessage : errorMessage + ".";
    }

    @Override
    public String stackTrace() {
        if (this.stackTrace.isEmpty()) {
            return "";
        }
        return this.header != null ? this.header + "\n" + this.stackTrace : this.stackTrace;
    }

    private String getStackTraceAsString(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        return sw.toString();
    }
}

