/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.apikit.scaffolding.internal.mapper;

import amf.apicontract.client.platform.AMFBaseUnitClient;
import amf.apicontract.client.platform.AMFConfiguration;
import amf.apicontract.client.platform.AsyncAPIConfiguration;
import amf.core.internal.remote.Spec;

public class AsyncApiGraphMapper extends AmfApiGraphMapper {

  @Override
  protected AMFBaseUnitClient getClient(String api) {
    return AsyncAPIConfiguration.Async20().withResourceLoader(new APISyncResourceLoader(api)).baseUnitClient();
  }

  @Override
  protected AMFConfiguration getConfiguration(Spec spec) {
    return AsyncAPIConfiguration.Async20();
  }
}
