/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.config;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;
import org.pitest.mutationtest.config.ReportDirCreationStrategy;
import org.pitest.util.ResultOutputStrategy;
import org.pitest.util.Unchecked;

public class DirectoryResultOutputStrategy
implements ResultOutputStrategy {
    private final File reportDir;

    public DirectoryResultOutputStrategy(String baseDir, ReportDirCreationStrategy dirCreationStrategy) {
        this.reportDir = dirCreationStrategy.createReportDir(baseDir);
    }

    private OutputStream createOutputStreamForFile(String file) {
        try {
            String directory;
            File directoryFile;
            int fileSepIndex = file.lastIndexOf(File.separatorChar);
            if (fileSepIndex > 0 && !(directoryFile = new File(directory = this.reportDir.getAbsolutePath() + File.separatorChar + file.substring(0, fileSepIndex))).exists()) {
                directoryFile.mkdirs();
            }
            return new FileOutputStream(this.reportDir.getAbsolutePath() + File.separatorChar + file);
        }
        catch (IOException ex) {
            throw Unchecked.translateCheckedException((Throwable)ex);
        }
    }

    @Override
    public Writer createWriterForFile(String file) {
        return new BufferedWriter(new OutputStreamWriter(this.createOutputStreamForFile(file)));
    }

    @Override
    public File getDumpDir() {
        File dumpDir = new File(this.reportDir, "pool");
        return dumpDir;
    }

    @Override
    public Writer createWriterForCompressedFile(String file) {
        try {
            GZIPOutputStream cos = new GZIPOutputStream(this.createOutputStreamForFile(file));
            return new BufferedWriter(new OutputStreamWriter(cos));
        }
        catch (IOException ex) {
            throw Unchecked.translateCheckedException((Throwable)ex);
        }
    }
}

