/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.equivalent;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.MethodMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.gregor.mutators.BooleanFalseReturnValsMutator;
import org.pitest.mutationtest.engine.gregor.mutators.PrimitiveReturnsMutator;

class PrimitiveEquivalentFilter
implements MutationInterceptor {
    private static final Set<String> MUTATOR_IDS = new HashSet<String>();
    private static final Set<Integer> ZERO_CONSTANTS = new HashSet<Integer>();
    private ClassTree currentClass;

    PrimitiveEquivalentFilter() {
    }

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    @Override
    public void begin(ClassTree clazz) {
        this.currentClass = clazz;
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        return FCollection.filter(mutations, (F)Prelude.not(this.isEquivalent(m)));
    }

    private F<MutationDetails, Boolean> isEquivalent(Mutater m) {
        return new F<MutationDetails, Boolean>(){

            public Boolean apply(MutationDetails a) {
                if (!MUTATOR_IDS.contains(a.getMutator())) {
                    return false;
                }
                int instructionBeforeReturn = a.getInstructionIndex() - 1;
                if (instructionBeforeReturn < 0) {
                    return false;
                }
                MethodTree method = (MethodTree)PrimitiveEquivalentFilter.this.currentClass.methods().findFirst(MethodMatchers.forLocation(a.getId().getLocation())).value();
                return ZERO_CONSTANTS.contains(((AbstractInsnNode)method.instructions().get(instructionBeforeReturn)).getOpcode());
            }
        };
    }

    @Override
    public void end() {
        this.currentClass = null;
    }

    static {
        ZERO_CONSTANTS.add(3);
        ZERO_CONSTANTS.add(9);
        ZERO_CONSTANTS.add(11);
        ZERO_CONSTANTS.add(14);
        MUTATOR_IDS.add(PrimitiveReturnsMutator.PRIMITIVE_RETURN_VALS_MUTATOR.getGloballyUniqueId());
        MUTATOR_IDS.add(BooleanFalseReturnValsMutator.BOOLEAN_FALSE_RETURN.getGloballyUniqueId());
    }
}

