/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.bytecode.analysis;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceClassVisitor;
import org.pitest.bytecode.analysis.MethodMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.classinfo.ClassName;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.FunctionalList;
import org.pitest.functional.MutableList;
import org.pitest.functional.Option;
import org.pitest.mutationtest.engine.Location;

public class ClassTree {
    private final ClassNode rawNode;
    private FunctionalList<MethodTree> lazyMethods;

    public ClassTree(ClassNode rawNode) {
        this.rawNode = rawNode;
    }

    public static ClassTree fromBytes(byte[] bytes) {
        ClassReader cr = new ClassReader(bytes);
        ClassNode classNode = new ClassNode();
        cr.accept(classNode, 8);
        return new ClassTree(classNode);
    }

    public FunctionalList<MethodTree> methods() {
        if (this.lazyMethods != null) {
            return this.lazyMethods;
        }
        this.lazyMethods = FCollection.map(this.rawNode.methods, ClassTree.toTree(this.name()));
        return this.lazyMethods;
    }

    public Option<MethodTree> method(Location loc) {
        return this.methods().findFirst(MethodMatchers.forLocation(loc));
    }

    public FunctionalList<AnnotationNode> annotations() {
        MutableList annotaions = new MutableList();
        if (this.rawNode.invisibleAnnotations != null) {
            annotaions.addAll(this.rawNode.invisibleAnnotations);
        }
        if (this.rawNode.visibleAnnotations != null) {
            annotaions.addAll(this.rawNode.visibleAnnotations);
        }
        return annotaions;
    }

    private static F<MethodNode, MethodTree> toTree(final ClassName name) {
        return new F<MethodNode, MethodTree>(){

            public MethodTree apply(MethodNode a) {
                return new MethodTree(name, a);
            }
        };
    }

    public ClassName name() {
        return ClassName.fromString((String)this.rawNode.name);
    }

    public ClassNode rawNode() {
        return this.rawNode;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        this.rawNode.accept(new TraceClassVisitor(null, new Textifier(), new PrintWriter(writer)));
        return writer.toString();
    }
}

