/*
 * Decompiled with CFR 0.152.
 */
package org.mudebug.prapr.report.log;

import java.util.Objects;
import org.mudebug.prapr.report.log.Commons;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.DetectionStatus;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.engine.MutationDetails;

public final class MutationResultWrapper {
    private final MutationResult mutationResult;

    private MutationResultWrapper(MutationResult mutationResult) {
        this.mutationResult = mutationResult;
    }

    public static MutationResultWrapper wrap(MutationResult mr) {
        return new MutationResultWrapper(mr);
    }

    public MutationResult getMutationResult() {
        return this.mutationResult;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutationResultWrapper that = (MutationResultWrapper)o;
        DetectionStatus status = this.mutationResult.getStatus();
        MutationDetails mutationDetails = this.mutationResult.getDetails();
        ClassName className = mutationDetails.getClassName();
        String mutatorId = Commons.sanitizeMutatorName(mutationDetails.getMutator());
        int lineNumber = mutationDetails.getLineNumber();
        String desc = mutationDetails.getDescription();
        return status == that.mutationResult.getStatus() && Objects.equals(className, that.mutationResult.getDetails().getClassName()) && Objects.equals(mutatorId, Commons.sanitizeMutatorName(that.mutationResult.getDetails().getMutator())) && lineNumber == that.mutationResult.getDetails().getLineNumber() && Objects.equals(desc, that.mutationResult.getDetails().getDescription());
    }

    public int hashCode() {
        DetectionStatus status = this.mutationResult.getStatus();
        MutationDetails mutationDetails = this.mutationResult.getDetails();
        ClassName className = mutationDetails.getClassName();
        String mutatorId = Commons.sanitizeMutatorName(mutationDetails.getMutator());
        int lineNumber = mutationDetails.getLineNumber();
        String desc = mutationDetails.getDescription();
        return Objects.hash(status, className, mutatorId, lineNumber, desc);
    }
}

