/*
 * Decompiled with CFR 0.152.
 */
package org.mudebug.prapr.report.log;

import java.io.File;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mudebug.prapr.report.log.Commons;
import org.mudebug.prapr.report.log.MutationResultWrapper;
import org.mudebug.prapr.report.log.SetRankFunction;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.mutationtest.ClassMutationResults;
import org.pitest.mutationtest.DetectionStatus;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.MutationResultListener;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.util.ResultOutputStrategy;

public class LOGReportListener
implements MutationResultListener {
    private final Writer out;
    private final Map<String, Double> mutatorScore;
    private final List<MutationResult> killedMutations;
    private final List<MutationResult> survivedMutations;
    private final Set<MutationResultWrapper> allMutations;

    public LOGReportListener(ResultOutputStrategy outStrategy) {
        this.out = outStrategy.createWriterForFile("fix-report.log");
        this.mutatorScore = new HashMap<String, Double>();
        this.killedMutations = new ArrayList<MutationResult>();
        this.survivedMutations = new ArrayList<MutationResult>();
        this.allMutations = new HashSet<MutationResultWrapper>();
    }

    private void writeln(String s) {
        try {
            this.out.write(s + "\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void computeMutatorScores() {
        String mutator;
        HashMap<String, Integer> totalCount = new HashMap<String, Integer>();
        HashMap<String, Integer> plausibleCount = new HashMap<String, Integer>();
        for (MutationResult mutationResult : this.killedMutations) {
            mutator = Commons.sanitizeMutatorName(mutationResult.getDetails().getMutator());
            this.inc(totalCount, mutator);
        }
        for (MutationResult mutationResult : this.survivedMutations) {
            mutator = Commons.sanitizeMutatorName(mutationResult.getDetails().getMutator());
            this.inc(plausibleCount, mutator);
            this.inc(totalCount, mutator);
        }
        for (Map.Entry entry : totalCount.entrySet()) {
            mutator = (String)entry.getKey();
            Integer num = (Integer)plausibleCount.get(mutator);
            if (num == null) {
                num = 0;
            }
            Integer denum = (Integer)entry.getValue();
            Double score = num.doubleValue() / denum.doubleValue();
            this.mutatorScore.put(mutator, score);
        }
    }

    private List<List<MutationDetails>> groupAndSortBySusp(List<List<MutationResult>> mutationsSuperList) {
        HashMap<Double, ArrayList<MutationDetails>> mutationsGroupedMap = new HashMap<Double, ArrayList<MutationDetails>>();
        for (List<MutationResult> mrl : mutationsSuperList) {
            for (MutationResult mr : mrl) {
                MutationDetails md = mr.getDetails();
                Double susp = md.getSusp();
                ArrayList<MutationDetails> group = (ArrayList<MutationDetails>)mutationsGroupedMap.get(susp);
                if (group == null) {
                    group = new ArrayList<MutationDetails>();
                    mutationsGroupedMap.put(susp, group);
                }
                group.add(md);
            }
        }
        ArrayList list = new ArrayList(mutationsGroupedMap.entrySet());
        mutationsGroupedMap = null;
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                Map.Entry e1 = (Map.Entry)o1;
                Map.Entry e2 = (Map.Entry)o2;
                return Double.compare((Double)e2.getKey(), (Double)e1.getKey());
            }
        });
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, ((Map.Entry)list.get(i)).getValue());
        }
        return list;
    }

    private List<List<MutationDetails>> groupAndSortByMutScore(List<MutationDetails> chunk) {
        Map mutationsGroupedMap = FCollection.bucket(chunk, (F)new F<MutationDetails, Double>(){

            public Double apply(MutationDetails md) {
                return (Double)LOGReportListener.this.mutatorScore.get(Commons.sanitizeMutatorName(md.getMutator()));
            }
        });
        ArrayList list = new ArrayList(mutationsGroupedMap.entrySet());
        mutationsGroupedMap = null;
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                Map.Entry e1 = (Map.Entry)o1;
                Map.Entry e2 = (Map.Entry)o2;
                return Double.compare((Double)e1.getKey(), (Double)e2.getKey());
            }
        });
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, ((Map.Entry)list.get(i)).getValue());
        }
        return list;
    }

    private void doRanking(SetRankFunction setRankFunction, List<List<MutationResult>> mutationsSuperList) {
        List<List<MutationDetails>> list = this.groupAndSortBySusp(mutationsSuperList);
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, this.groupAndSortByMutScore(list.get(i)));
        }
        List finalSorted = (List)FCollection.flatten(list);
        int rank = 0;
        for (List mdl : finalSorted) {
            rank += mdl.size();
            for (MutationDetails md : mdl) {
                setRankFunction.setRank(md, rank);
            }
        }
    }

    private void inc(Map<String, Integer> countMap, String mutator) {
        Integer count = countMap.get(mutator);
        if (count == null) {
            count = 0;
        }
        countMap.put(mutator, count + 1);
    }

    private void thickLine() {
        this.writeln("================================================");
    }

    private void thinLine() {
        this.writeln("------------------------------------------------");
    }

    @Override
    public void runStart() {
        this.writeln("PraPR 2 (JDK 1.7) Fix Report - " + new Date().toString());
    }

    @Override
    public void handleMutationResult(ClassMutationResults results) {
        for (MutationResult mr : results.getMutations()) {
            this.allMutations.add(MutationResultWrapper.wrap(mr));
        }
    }

    private void printRankedList() {
        int plausiblesSize = this.survivedMutations.size();
        int totalSize = this.killedMutations.size() + plausiblesSize;
        this.writeln("Number of Plausible Fixes: " + plausiblesSize);
        this.writeln("Total Number of Patches: " + totalSize);
        this.thickLine();
        if (plausiblesSize == 0) {
            this.writeln("No fix found!");
            return;
        }
        this.computeMutatorScores();
        this.doRanking(new SetRankFunction(){

            @Override
            public void setRank(MutationDetails md, int rank) {
                md.setPlRank(rank);
            }
        }, Arrays.asList(this.survivedMutations));
        this.doRanking(new SetRankFunction(){

            @Override
            public void setRank(MutationDetails md, int rank) {
                md.setAllRank(rank);
            }
        }, Arrays.asList(this.survivedMutations, this.killedMutations));
        Collections.sort(this.survivedMutations, new Comparator<MutationResult>(){

            @Override
            public int compare(MutationResult mr1, MutationResult mr2) {
                MutationDetails md1 = mr1.getDetails();
                MutationDetails md2 = mr2.getDetails();
                return Integer.compare(md1.getPlRank(), md2.getPlRank());
            }
        });
        for (int i = 0; i < this.survivedMutations.size(); ++i) {
            MutationDetails md = this.survivedMutations.get(i).getDetails();
            this.printMutationDetails(1 + i, md);
            this.thinLine();
        }
    }

    private void printMutationDetails(int row, MutationDetails md) {
        this.writeln(String.format("%d.", row));
        this.writeln(String.format("\tMutator: %s", Commons.sanitizeMutatorName(md.getMutator())));
        this.writeln(String.format("\tDescription: %s", md.getDescription()));
        String mutatedClass = md.getClassName().asInternalName();
        int lastSlash = mutatedClass.lastIndexOf(47);
        String filePath = lastSlash >= 0 ? mutatedClass.substring(0, 1 + lastSlash) : "";
        this.writeln(String.format("\tFile Name: %s%s", filePath, md.getFilename()));
        this.writeln(String.format("\tLine Number: %d", md.getLineNumber()));
        this.writeln(String.format("\tRank: %d", md.getPlRank()));
        this.writeln(String.format("\tTotal Rank: %d", md.getAllRank()));
        File dumpFile = md.getDumpFile();
        if (dumpFile != null) {
            this.writeln(String.format("\tDump: %s", dumpFile.getName()));
        }
    }

    private void multiplexMutations() {
        Iterator<MutationResultWrapper> mit = this.allMutations.iterator();
        while (mit.hasNext()) {
            MutationResult mr = mit.next().getMutationResult();
            if (mr.getStatus() == DetectionStatus.SURVIVED) {
                this.survivedMutations.add(mr);
                mr.getDetails().setDumpFile(mr.getStatusTestPair().getDumpFile());
            } else {
                this.killedMutations.add(mr);
            }
            mit.remove();
        }
    }

    @Override
    public void runEnd() {
        try {
            this.multiplexMutations();
            this.printRankedList();
            this.out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

