/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jackson.dataformat;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.MapperBuilder;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.msgpack.jackson.dataformat.MessagePackFactory;

public class MessagePackMapper
extends ObjectMapper {
    private static final long serialVersionUID = 3L;

    public MessagePackMapper() {
        this(new MessagePackFactory());
    }

    public MessagePackMapper(MessagePackFactory messagePackFactory) {
        super((JsonFactory)messagePackFactory);
    }

    public MessagePackMapper handleBigIntegerAsString() {
        this.configOverride(BigInteger.class).setFormat(JsonFormat.Value.forShape((JsonFormat.Shape)JsonFormat.Shape.STRING));
        return this;
    }

    public MessagePackMapper handleBigDecimalAsString() {
        this.configOverride(BigDecimal.class).setFormat(JsonFormat.Value.forShape((JsonFormat.Shape)JsonFormat.Shape.STRING));
        return this;
    }

    public MessagePackMapper handleBigIntegerAndBigDecimalAsString() {
        return this.handleBigIntegerAsString().handleBigDecimalAsString();
    }

    public static Builder builder() {
        return new Builder(new MessagePackMapper());
    }

    public static Builder builder(MessagePackFactory messagePackFactory) {
        return new Builder(new MessagePackMapper(messagePackFactory));
    }

    public static class Builder
    extends MapperBuilder<MessagePackMapper, Builder> {
        public Builder(MessagePackMapper messagePackMapper) {
            super((ObjectMapper)messagePackMapper);
        }
    }
}

