/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.client.internal.Crypt;
import com.mongodb.client.internal.CryptConnection;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.binding.ClusterAwareReadWriteBinding;
import com.mongodb.internal.binding.ConnectionSource;
import com.mongodb.internal.binding.ReadWriteBinding;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.connection.OperationContext;

class CryptBinding
implements ClusterAwareReadWriteBinding {
    private final ClusterAwareReadWriteBinding wrapped;
    private final Crypt crypt;

    CryptBinding(ClusterAwareReadWriteBinding wrapped, Crypt crypt) {
        this.crypt = crypt;
        this.wrapped = wrapped;
    }

    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    public ConnectionSource getReadConnectionSource(OperationContext operationContext) {
        return new CryptConnectionSource(this.wrapped.getReadConnectionSource(operationContext));
    }

    public ConnectionSource getReadConnectionSource(int minWireVersion, ReadPreference fallbackReadPreference, OperationContext operationContext) {
        return new CryptConnectionSource(this.wrapped.getReadConnectionSource(minWireVersion, fallbackReadPreference, operationContext));
    }

    public ConnectionSource getWriteConnectionSource(OperationContext operationContext) {
        return new CryptConnectionSource(this.wrapped.getWriteConnectionSource(operationContext));
    }

    public ConnectionSource getConnectionSource(ServerAddress serverAddress, OperationContext operationContext) {
        return new CryptConnectionSource(this.wrapped.getConnectionSource(serverAddress, operationContext));
    }

    public int getCount() {
        return this.wrapped.getCount();
    }

    public ReadWriteBinding retain() {
        this.wrapped.retain();
        return this;
    }

    public int release() {
        return this.wrapped.release();
    }

    private class CryptConnectionSource
    implements ConnectionSource {
        private final ConnectionSource wrapped;

        CryptConnectionSource(ConnectionSource wrapped) {
            this.wrapped = wrapped;
        }

        public ServerDescription getServerDescription() {
            return this.wrapped.getServerDescription();
        }

        public ReadPreference getReadPreference() {
            return this.wrapped.getReadPreference();
        }

        public Connection getConnection(OperationContext operationContext) {
            return new CryptConnection(this.wrapped.getConnection(operationContext), CryptBinding.this.crypt);
        }

        public int getCount() {
            return this.wrapped.getCount();
        }

        public ConnectionSource retain() {
            this.wrapped.retain();
            return this;
        }

        public int release() {
            return this.wrapped.release();
        }
    }
}

