/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.rx.client;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.rx.client.AggregateObservable;
import com.mongodb.rx.client.DistinctObservable;
import com.mongodb.rx.client.FindObservable;
import com.mongodb.rx.client.ListIndexesObservable;
import com.mongodb.rx.client.MapReduceObservable;
import com.mongodb.rx.client.ObservableAdapter;
import com.mongodb.rx.client.Success;
import java.util.List;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import rx.Observable;

@ThreadSafe
public interface MongoCollection<TDocument> {
    public MongoNamespace getNamespace();

    public Class<TDocument> getDocumentClass();

    public ObservableAdapter getObservableAdapter();

    public CodecRegistry getCodecRegistry();

    public ReadPreference getReadPreference();

    public WriteConcern getWriteConcern();

    public ReadConcern getReadConcern();

    public <NewTDocument> MongoCollection<NewTDocument> withDocumentClass(Class<NewTDocument> var1);

    public MongoCollection<TDocument> withCodecRegistry(CodecRegistry var1);

    public MongoCollection<TDocument> withReadPreference(ReadPreference var1);

    public MongoCollection<TDocument> withWriteConcern(WriteConcern var1);

    public MongoCollection<TDocument> withReadConcern(ReadConcern var1);

    public MongoCollection<TDocument> withObservableAdapter(ObservableAdapter var1);

    public Observable<Long> count();

    public Observable<Long> count(Bson var1);

    public Observable<Long> count(Bson var1, CountOptions var2);

    public <TResult> DistinctObservable<TResult> distinct(String var1, Class<TResult> var2);

    public <TResult> DistinctObservable<TResult> distinct(String var1, Bson var2, Class<TResult> var3);

    public FindObservable<TDocument> find();

    public <TResult> FindObservable<TResult> find(Class<TResult> var1);

    public FindObservable<TDocument> find(Bson var1);

    public <TResult> FindObservable<TResult> find(Bson var1, Class<TResult> var2);

    public AggregateObservable<Document> aggregate(List<? extends Bson> var1);

    public <TResult> AggregateObservable<TResult> aggregate(List<? extends Bson> var1, Class<TResult> var2);

    public MapReduceObservable<Document> mapReduce(String var1, String var2);

    public <TResult> MapReduceObservable<TResult> mapReduce(String var1, String var2, Class<TResult> var3);

    public Observable<BulkWriteResult> bulkWrite(List<? extends WriteModel<? extends TDocument>> var1);

    public Observable<BulkWriteResult> bulkWrite(List<? extends WriteModel<? extends TDocument>> var1, BulkWriteOptions var2);

    public Observable<Success> insertOne(TDocument var1);

    public Observable<Success> insertOne(TDocument var1, InsertOneOptions var2);

    public Observable<Success> insertMany(List<? extends TDocument> var1);

    public Observable<Success> insertMany(List<? extends TDocument> var1, InsertManyOptions var2);

    public Observable<DeleteResult> deleteOne(Bson var1);

    public Observable<DeleteResult> deleteMany(Bson var1);

    public Observable<UpdateResult> replaceOne(Bson var1, TDocument var2);

    public Observable<UpdateResult> replaceOne(Bson var1, TDocument var2, UpdateOptions var3);

    public Observable<UpdateResult> updateOne(Bson var1, Bson var2);

    public Observable<UpdateResult> updateOne(Bson var1, Bson var2, UpdateOptions var3);

    public Observable<UpdateResult> updateMany(Bson var1, Bson var2);

    public Observable<UpdateResult> updateMany(Bson var1, Bson var2, UpdateOptions var3);

    public Observable<TDocument> findOneAndDelete(Bson var1);

    public Observable<TDocument> findOneAndDelete(Bson var1, FindOneAndDeleteOptions var2);

    public Observable<TDocument> findOneAndReplace(Bson var1, TDocument var2);

    public Observable<TDocument> findOneAndReplace(Bson var1, TDocument var2, FindOneAndReplaceOptions var3);

    public Observable<TDocument> findOneAndUpdate(Bson var1, Bson var2);

    public Observable<TDocument> findOneAndUpdate(Bson var1, Bson var2, FindOneAndUpdateOptions var3);

    public Observable<Success> drop();

    public Observable<String> createIndex(Bson var1);

    public Observable<String> createIndex(Bson var1, IndexOptions var2);

    public Observable<String> createIndexes(List<IndexModel> var1);

    public ListIndexesObservable<Document> listIndexes();

    public <TResult> ListIndexesObservable<TResult> listIndexes(Class<TResult> var1);

    public Observable<Success> dropIndex(String var1);

    public Observable<Success> dropIndex(Bson var1);

    public Observable<Success> dropIndexes();

    public Observable<Success> renameCollection(MongoNamespace var1);

    public Observable<Success> renameCollection(MongoNamespace var1, RenameCollectionOptions var2);
}

