/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.rx.client;

import com.mongodb.ConnectionString;
import com.mongodb.async.client.MongoClientSettings;
import com.mongodb.rx.client.MongoClient;
import com.mongodb.rx.client.MongoClientImpl;
import com.mongodb.rx.client.ObservableAdapter;
import com.mongodb.rx.client.ObservableHelper;

public final class MongoClients {
    public static MongoClient create() {
        return MongoClients.create(new ConnectionString("mongodb://localhost"));
    }

    public static MongoClient create(MongoClientSettings settings) {
        return MongoClients.create(settings, (ObservableAdapter)new ObservableHelper.NoopObservableAdapter());
    }

    public static MongoClient create(MongoClientSettings settings, ObservableAdapter observableAdapter) {
        return new MongoClientImpl(com.mongodb.async.client.MongoClients.create((MongoClientSettings)settings), observableAdapter);
    }

    public static MongoClient create(String connectionString) {
        return MongoClients.create(new ConnectionString(connectionString));
    }

    public static MongoClient create(String connectionString, ObservableAdapter observableAdapter) {
        return MongoClients.create(new ConnectionString(connectionString), observableAdapter);
    }

    public static MongoClient create(ConnectionString connectionString) {
        return MongoClients.create(connectionString, (ObservableAdapter)new ObservableHelper.NoopObservableAdapter());
    }

    public static MongoClient create(ConnectionString connectionString, ObservableAdapter observableAdapter) {
        return new MongoClientImpl(com.mongodb.async.client.MongoClients.create((ConnectionString)connectionString), observableAdapter);
    }

    private MongoClients() {
    }
}

