/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.rx.client;

import com.mongodb.assertions.Assertions;
import com.mongodb.async.client.ListCollectionsIterable;
import com.mongodb.async.client.Observables;
import com.mongodb.rx.client.ListCollectionsObservable;
import com.mongodb.rx.client.ObservableAdapter;
import com.mongodb.rx.client.RxObservables;
import java.util.concurrent.TimeUnit;
import org.bson.conversions.Bson;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;

final class ListCollectionsObservableImpl<TResult>
implements ListCollectionsObservable<TResult> {
    private final ListCollectionsIterable<TResult> wrapped;
    private final ObservableAdapter observableAdapter;

    ListCollectionsObservableImpl(ListCollectionsIterable<TResult> wrapped, ObservableAdapter observableAdapter) {
        this.wrapped = (ListCollectionsIterable)Assertions.notNull((String)"wrapped", wrapped);
        this.observableAdapter = (ObservableAdapter)Assertions.notNull((String)"observableAdapter", (Object)observableAdapter);
    }

    @Override
    public ListCollectionsObservable<TResult> filter(Bson filter) {
        Assertions.notNull((String)"filter", (Object)filter);
        this.wrapped.filter(filter);
        return this;
    }

    @Override
    public ListCollectionsObservable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.wrapped.maxTime(maxTime, timeUnit);
        return this;
    }

    @Override
    public Observable<TResult> toObservable() {
        return RxObservables.create(Observables.observe(this.wrapped), this.observableAdapter);
    }

    @Override
    public Subscription subscribe(Subscriber<? super TResult> subscriber) {
        return this.toObservable().subscribe(subscriber);
    }
}

