/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal.crypt;

import com.mongodb.assertions.Assertions;
import com.mongodb.internal.time.Timeout;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.internal.TimeoutHelper;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import reactor.core.publisher.Mono;

class CollectionInfoRetriever {
    private static final String TIMEOUT_ERROR_MESSAGE = "Collection information retrieval exceeded the timeout limit.";
    private final MongoClient client;

    CollectionInfoRetriever(MongoClient client) {
        this.client = (MongoClient)Assertions.notNull((String)"client", (Object)client);
    }

    public Mono<BsonDocument> filter(String databaseName, BsonDocument filter, @Nullable Timeout operationTimeout) {
        return TimeoutHelper.databaseWithTimeoutDeferred(this.client.getDatabase(databaseName), TIMEOUT_ERROR_MESSAGE, operationTimeout).flatMap(database -> Mono.from(database.listCollections(BsonDocument.class).filter((Bson)filter).first()));
    }
}

