/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.DropCollectionOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.EstimatedDocumentCountOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.SearchIndexModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertManyResult;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.internal.client.model.AggregationLevel;
import com.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import com.mongodb.reactivestreams.client.AggregatePublisher;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.DistinctPublisher;
import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.ListIndexesPublisher;
import com.mongodb.reactivestreams.client.ListSearchIndexesPublisher;
import com.mongodb.reactivestreams.client.MapReducePublisher;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.internal.AggregatePublisherImpl;
import com.mongodb.reactivestreams.client.internal.ChangeStreamPublisherImpl;
import com.mongodb.reactivestreams.client.internal.DistinctPublisherImpl;
import com.mongodb.reactivestreams.client.internal.FindPublisherImpl;
import com.mongodb.reactivestreams.client.internal.ListIndexesPublisherImpl;
import com.mongodb.reactivestreams.client.internal.ListSearchIndexesPublisherImpl;
import com.mongodb.reactivestreams.client.internal.MapReducePublisherImpl;
import com.mongodb.reactivestreams.client.internal.MongoOperationPublisher;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;

final class MongoCollectionImpl<T>
implements MongoCollection<T> {
    private final MongoOperationPublisher<T> mongoOperationPublisher;

    MongoCollectionImpl(MongoOperationPublisher<T> mongoOperationPublisher) {
        this.mongoOperationPublisher = (MongoOperationPublisher)Assertions.notNull((String)"mongoOperationPublisher", mongoOperationPublisher);
    }

    @Override
    public MongoNamespace getNamespace() {
        return (MongoNamespace)Assertions.assertNotNull((Object)this.mongoOperationPublisher.getNamespace());
    }

    @Override
    public Class<T> getDocumentClass() {
        return this.mongoOperationPublisher.getDocumentClass();
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.mongoOperationPublisher.getCodecRegistry();
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.mongoOperationPublisher.getReadPreference();
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.mongoOperationPublisher.getWriteConcern();
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.mongoOperationPublisher.getReadConcern();
    }

    @Override
    public Long getTimeout(TimeUnit timeUnit) {
        Long timeoutMS = this.mongoOperationPublisher.getTimeoutMS();
        return timeoutMS != null ? Long.valueOf(((TimeUnit)((Object)Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit)))).convert(timeoutMS, TimeUnit.MILLISECONDS)) : null;
    }

    MongoOperationPublisher<T> getPublisherHelper() {
        return this.mongoOperationPublisher;
    }

    @Override
    public <D> MongoCollection<D> withDocumentClass(Class<D> newDocumentClass) {
        return new MongoCollectionImpl<D>(this.mongoOperationPublisher.withDocumentClass(newDocumentClass));
    }

    @Override
    public MongoCollection<T> withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoCollectionImpl<T>(this.mongoOperationPublisher.withCodecRegistry(codecRegistry));
    }

    @Override
    public MongoCollection<T> withReadPreference(ReadPreference readPreference) {
        return new MongoCollectionImpl<T>(this.mongoOperationPublisher.withReadPreference(readPreference));
    }

    @Override
    public MongoCollection<T> withWriteConcern(WriteConcern writeConcern) {
        return new MongoCollectionImpl<T>(this.mongoOperationPublisher.withWriteConcern(writeConcern));
    }

    @Override
    public MongoCollection<T> withReadConcern(ReadConcern readConcern) {
        return new MongoCollectionImpl<T>(this.mongoOperationPublisher.withReadConcern(readConcern));
    }

    @Override
    public MongoCollection<T> withTimeout(long timeout, TimeUnit timeUnit) {
        return new MongoCollectionImpl<T>(this.mongoOperationPublisher.withTimeout(timeout, timeUnit));
    }

    @Override
    public Publisher<Long> estimatedDocumentCount() {
        return this.estimatedDocumentCount(new EstimatedDocumentCountOptions());
    }

    @Override
    public Publisher<Long> estimatedDocumentCount(EstimatedDocumentCountOptions options) {
        return this.mongoOperationPublisher.estimatedDocumentCount(options);
    }

    @Override
    public Publisher<Long> countDocuments() {
        return this.countDocuments((Bson)new BsonDocument());
    }

    @Override
    public Publisher<Long> countDocuments(Bson filter) {
        return this.countDocuments(filter, new CountOptions());
    }

    @Override
    public Publisher<Long> countDocuments(Bson filter, CountOptions options) {
        return this.mongoOperationPublisher.countDocuments(null, filter, options);
    }

    @Override
    public Publisher<Long> countDocuments(ClientSession clientSession) {
        return this.countDocuments(clientSession, (Bson)new BsonDocument());
    }

    @Override
    public Publisher<Long> countDocuments(ClientSession clientSession, Bson filter) {
        return this.countDocuments(clientSession, filter, new CountOptions());
    }

    @Override
    public Publisher<Long> countDocuments(ClientSession clientSession, Bson filter, CountOptions options) {
        return this.mongoOperationPublisher.countDocuments((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), filter, options);
    }

    @Override
    public <TResult> DistinctPublisher<TResult> distinct(String fieldName, Class<TResult> resultClass) {
        return this.distinct(fieldName, (Bson)new BsonDocument(), resultClass);
    }

    @Override
    public <TResult> DistinctPublisher<TResult> distinct(String fieldName, Bson filter, Class<TResult> resultClass) {
        return new DistinctPublisherImpl<TResult>(null, this.mongoOperationPublisher.withDocumentClass(resultClass), fieldName, filter);
    }

    @Override
    public <TResult> DistinctPublisher<TResult> distinct(ClientSession clientSession, String fieldName, Class<TResult> resultClass) {
        return this.distinct(clientSession, fieldName, (Bson)new BsonDocument(), resultClass);
    }

    @Override
    public <TResult> DistinctPublisher<TResult> distinct(ClientSession clientSession, String fieldName, Bson filter, Class<TResult> resultClass) {
        return new DistinctPublisherImpl<TResult>((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), this.mongoOperationPublisher.withDocumentClass(resultClass), fieldName, filter);
    }

    @Override
    public FindPublisher<T> find() {
        return this.find((Bson)new BsonDocument(), this.getDocumentClass());
    }

    @Override
    public <TResult> FindPublisher<TResult> find(Class<TResult> resultClass) {
        return this.find((Bson)new BsonDocument(), resultClass);
    }

    @Override
    public FindPublisher<T> find(Bson filter) {
        return this.find(filter, this.getDocumentClass());
    }

    @Override
    public <TResult> FindPublisher<TResult> find(Bson filter, Class<TResult> resultClass) {
        return new FindPublisherImpl<TResult>(null, this.mongoOperationPublisher.withDocumentClass(resultClass), filter);
    }

    @Override
    public FindPublisher<T> find(ClientSession clientSession) {
        return this.find(clientSession, (Bson)new BsonDocument(), this.getDocumentClass());
    }

    @Override
    public <TResult> FindPublisher<TResult> find(ClientSession clientSession, Class<TResult> resultClass) {
        return this.find(clientSession, (Bson)new BsonDocument(), resultClass);
    }

    @Override
    public FindPublisher<T> find(ClientSession clientSession, Bson filter) {
        return this.find(clientSession, filter, this.getDocumentClass());
    }

    @Override
    public <TResult> FindPublisher<TResult> find(ClientSession clientSession, Bson filter, Class<TResult> resultClass) {
        return new FindPublisherImpl<TResult>((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), this.mongoOperationPublisher.withDocumentClass(resultClass), filter);
    }

    @Override
    public AggregatePublisher<T> aggregate(List<? extends Bson> pipeline) {
        return this.aggregate(pipeline, this.getDocumentClass());
    }

    @Override
    public <TResult> AggregatePublisher<TResult> aggregate(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new AggregatePublisherImpl<TResult>(null, this.mongoOperationPublisher.withDocumentClass(resultClass), pipeline, AggregationLevel.COLLECTION);
    }

    @Override
    public AggregatePublisher<T> aggregate(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.aggregate(clientSession, pipeline, this.getDocumentClass());
    }

    @Override
    public <TResult> AggregatePublisher<TResult> aggregate(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new AggregatePublisherImpl<TResult>((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), this.mongoOperationPublisher.withDocumentClass(resultClass), pipeline, AggregationLevel.COLLECTION);
    }

    @Override
    public ChangeStreamPublisher<Document> watch() {
        return this.watch(Document.class);
    }

    @Override
    public <TResult> ChangeStreamPublisher<TResult> watch(Class<TResult> resultClass) {
        return this.watch(Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamPublisher<Document> watch(List<? extends Bson> pipeline) {
        return this.watch(pipeline, Document.class);
    }

    @Override
    public <TResult> ChangeStreamPublisher<TResult> watch(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new ChangeStreamPublisherImpl<TResult>(null, this.mongoOperationPublisher, resultClass, pipeline, ChangeStreamLevel.COLLECTION);
    }

    @Override
    public ChangeStreamPublisher<Document> watch(ClientSession clientSession) {
        return this.watch(clientSession, Document.class);
    }

    @Override
    public <TResult> ChangeStreamPublisher<TResult> watch(ClientSession clientSession, Class<TResult> resultClass) {
        return this.watch(clientSession, Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamPublisher<Document> watch(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.watch(clientSession, pipeline, Document.class);
    }

    @Override
    public <TResult> ChangeStreamPublisher<TResult> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new ChangeStreamPublisherImpl<TResult>((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), this.mongoOperationPublisher, resultClass, pipeline, ChangeStreamLevel.COLLECTION);
    }

    @Override
    public MapReducePublisher<T> mapReduce(String mapFunction, String reduceFunction) {
        return this.mapReduce(mapFunction, reduceFunction, this.getDocumentClass());
    }

    @Override
    public <TResult> MapReducePublisher<TResult> mapReduce(String mapFunction, String reduceFunction, Class<TResult> resultClass) {
        return new MapReducePublisherImpl<TResult>(null, this.mongoOperationPublisher.withDocumentClass(resultClass), mapFunction, reduceFunction);
    }

    @Override
    public MapReducePublisher<T> mapReduce(ClientSession clientSession, String mapFunction, String reduceFunction) {
        return this.mapReduce(clientSession, mapFunction, reduceFunction, this.getDocumentClass());
    }

    @Override
    public <TResult> MapReducePublisher<TResult> mapReduce(ClientSession clientSession, String mapFunction, String reduceFunction, Class<TResult> resultClass) {
        return new MapReducePublisherImpl<TResult>((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), this.mongoOperationPublisher.withDocumentClass(resultClass), mapFunction, reduceFunction);
    }

    @Override
    public Publisher<BulkWriteResult> bulkWrite(List<? extends WriteModel<? extends T>> requests) {
        return this.bulkWrite(requests, new BulkWriteOptions());
    }

    @Override
    public Publisher<BulkWriteResult> bulkWrite(List<? extends WriteModel<? extends T>> requests, BulkWriteOptions options) {
        return this.mongoOperationPublisher.bulkWrite(null, requests, options);
    }

    @Override
    public Publisher<BulkWriteResult> bulkWrite(ClientSession clientSession, List<? extends WriteModel<? extends T>> requests) {
        return this.bulkWrite(clientSession, requests, new BulkWriteOptions());
    }

    @Override
    public Publisher<BulkWriteResult> bulkWrite(ClientSession clientSession, List<? extends WriteModel<? extends T>> requests, BulkWriteOptions options) {
        return this.mongoOperationPublisher.bulkWrite((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), requests, options);
    }

    @Override
    public Publisher<InsertOneResult> insertOne(T document) {
        return this.insertOne(document, new InsertOneOptions());
    }

    @Override
    public Publisher<InsertOneResult> insertOne(T document, InsertOneOptions options) {
        return this.mongoOperationPublisher.insertOne(null, document, options);
    }

    @Override
    public Publisher<InsertOneResult> insertOne(ClientSession clientSession, T document) {
        return this.insertOne(clientSession, document, new InsertOneOptions());
    }

    @Override
    public Publisher<InsertOneResult> insertOne(ClientSession clientSession, T document, InsertOneOptions options) {
        return this.mongoOperationPublisher.insertOne((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), document, options);
    }

    @Override
    public Publisher<InsertManyResult> insertMany(List<? extends T> documents) {
        return this.insertMany(documents, new InsertManyOptions());
    }

    @Override
    public Publisher<InsertManyResult> insertMany(List<? extends T> documents, InsertManyOptions options) {
        return this.mongoOperationPublisher.insertMany(null, documents, options);
    }

    @Override
    public Publisher<InsertManyResult> insertMany(ClientSession clientSession, List<? extends T> documents) {
        return this.insertMany(clientSession, documents, new InsertManyOptions());
    }

    @Override
    public Publisher<InsertManyResult> insertMany(ClientSession clientSession, List<? extends T> documents, InsertManyOptions options) {
        return this.mongoOperationPublisher.insertMany((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), documents, options);
    }

    @Override
    public Publisher<DeleteResult> deleteOne(Bson filter) {
        return this.deleteOne(filter, new DeleteOptions());
    }

    @Override
    public Publisher<DeleteResult> deleteOne(Bson filter, DeleteOptions options) {
        return this.mongoOperationPublisher.deleteOne(null, filter, options);
    }

    @Override
    public Publisher<DeleteResult> deleteOne(ClientSession clientSession, Bson filter) {
        return this.deleteOne(clientSession, filter, new DeleteOptions());
    }

    @Override
    public Publisher<DeleteResult> deleteOne(ClientSession clientSession, Bson filter, DeleteOptions options) {
        return this.mongoOperationPublisher.deleteOne((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), filter, options);
    }

    @Override
    public Publisher<DeleteResult> deleteMany(Bson filter) {
        return this.deleteMany(filter, new DeleteOptions());
    }

    @Override
    public Publisher<DeleteResult> deleteMany(Bson filter, DeleteOptions options) {
        return this.mongoOperationPublisher.deleteMany(null, filter, options);
    }

    @Override
    public Publisher<DeleteResult> deleteMany(ClientSession clientSession, Bson filter) {
        return this.deleteMany(clientSession, filter, new DeleteOptions());
    }

    @Override
    public Publisher<DeleteResult> deleteMany(ClientSession clientSession, Bson filter, DeleteOptions options) {
        return this.mongoOperationPublisher.deleteMany((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), filter, options);
    }

    @Override
    public Publisher<UpdateResult> replaceOne(Bson filter, T replacement) {
        return this.replaceOne(filter, replacement, new ReplaceOptions());
    }

    @Override
    public Publisher<UpdateResult> replaceOne(Bson filter, T replacement, ReplaceOptions options) {
        return this.mongoOperationPublisher.replaceOne(null, filter, replacement, options);
    }

    @Override
    public Publisher<UpdateResult> replaceOne(ClientSession clientSession, Bson filter, T replacement) {
        return this.replaceOne(clientSession, filter, replacement, new ReplaceOptions());
    }

    @Override
    public Publisher<UpdateResult> replaceOne(ClientSession clientSession, Bson filter, T replacement, ReplaceOptions options) {
        return this.mongoOperationPublisher.replaceOne((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), filter, replacement, options);
    }

    @Override
    public Publisher<UpdateResult> updateOne(Bson filter, Bson update) {
        return this.updateOne(filter, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateOne(Bson filter, Bson update, UpdateOptions options) {
        return this.mongoOperationPublisher.updateOne(null, filter, update, options);
    }

    @Override
    public Publisher<UpdateResult> updateOne(ClientSession clientSession, Bson filter, Bson update) {
        return this.updateOne(clientSession, filter, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateOne(ClientSession clientSession, Bson filter, Bson update, UpdateOptions options) {
        return this.mongoOperationPublisher.updateOne((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), filter, update, options);
    }

    @Override
    public Publisher<UpdateResult> updateOne(Bson filter, List<? extends Bson> update) {
        return this.updateOne(filter, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateOne(Bson filter, List<? extends Bson> update, UpdateOptions options) {
        return this.mongoOperationPublisher.updateOne(null, filter, update, options);
    }

    @Override
    public Publisher<UpdateResult> updateOne(ClientSession clientSession, Bson filter, List<? extends Bson> update) {
        return this.updateOne(clientSession, filter, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateOne(ClientSession clientSession, Bson filter, List<? extends Bson> update, UpdateOptions options) {
        return this.mongoOperationPublisher.updateOne((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), filter, update, options);
    }

    @Override
    public Publisher<UpdateResult> updateMany(Bson filter, Bson update) {
        return this.updateMany(filter, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateMany(Bson filter, Bson update, UpdateOptions options) {
        return this.mongoOperationPublisher.updateMany(null, filter, update, options);
    }

    @Override
    public Publisher<UpdateResult> updateMany(ClientSession clientSession, Bson filter, Bson update) {
        return this.updateMany(clientSession, filter, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateMany(ClientSession clientSession, Bson filter, Bson update, UpdateOptions options) {
        return this.mongoOperationPublisher.updateMany((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), filter, update, options);
    }

    @Override
    public Publisher<UpdateResult> updateMany(Bson filter, List<? extends Bson> update) {
        return this.updateMany(filter, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateMany(Bson filter, List<? extends Bson> update, UpdateOptions options) {
        return this.mongoOperationPublisher.updateMany(null, filter, update, options);
    }

    @Override
    public Publisher<UpdateResult> updateMany(ClientSession clientSession, Bson filter, List<? extends Bson> update) {
        return this.updateMany(clientSession, filter, update, new UpdateOptions());
    }

    @Override
    public Publisher<UpdateResult> updateMany(ClientSession clientSession, Bson filter, List<? extends Bson> update, UpdateOptions options) {
        return this.mongoOperationPublisher.updateMany((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), filter, update, options);
    }

    @Override
    public Publisher<T> findOneAndDelete(Bson filter) {
        return this.findOneAndDelete(filter, new FindOneAndDeleteOptions());
    }

    @Override
    public Publisher<T> findOneAndDelete(Bson filter, FindOneAndDeleteOptions options) {
        return this.mongoOperationPublisher.findOneAndDelete(null, filter, options);
    }

    @Override
    public Publisher<T> findOneAndDelete(ClientSession clientSession, Bson filter) {
        return this.findOneAndDelete(clientSession, filter, new FindOneAndDeleteOptions());
    }

    @Override
    public Publisher<T> findOneAndDelete(ClientSession clientSession, Bson filter, FindOneAndDeleteOptions options) {
        return this.mongoOperationPublisher.findOneAndDelete((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), filter, options);
    }

    @Override
    public Publisher<T> findOneAndReplace(Bson filter, T replacement) {
        return this.findOneAndReplace(filter, replacement, new FindOneAndReplaceOptions());
    }

    @Override
    public Publisher<T> findOneAndReplace(Bson filter, T replacement, FindOneAndReplaceOptions options) {
        return this.mongoOperationPublisher.findOneAndReplace(null, filter, replacement, options);
    }

    @Override
    public Publisher<T> findOneAndReplace(ClientSession clientSession, Bson filter, T replacement) {
        return this.findOneAndReplace(clientSession, filter, replacement, new FindOneAndReplaceOptions());
    }

    @Override
    public Publisher<T> findOneAndReplace(ClientSession clientSession, Bson filter, T replacement, FindOneAndReplaceOptions options) {
        return this.mongoOperationPublisher.findOneAndReplace((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), filter, replacement, options);
    }

    @Override
    public Publisher<T> findOneAndUpdate(Bson filter, Bson update) {
        return this.findOneAndUpdate(filter, update, new FindOneAndUpdateOptions());
    }

    @Override
    public Publisher<T> findOneAndUpdate(Bson filter, Bson update, FindOneAndUpdateOptions options) {
        return this.mongoOperationPublisher.findOneAndUpdate(null, filter, update, options);
    }

    @Override
    public Publisher<T> findOneAndUpdate(ClientSession clientSession, Bson filter, Bson update) {
        return this.findOneAndUpdate(clientSession, filter, update, new FindOneAndUpdateOptions());
    }

    @Override
    public Publisher<T> findOneAndUpdate(ClientSession clientSession, Bson filter, Bson update, FindOneAndUpdateOptions options) {
        return this.mongoOperationPublisher.findOneAndUpdate((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), filter, update, options);
    }

    @Override
    public Publisher<T> findOneAndUpdate(Bson filter, List<? extends Bson> update) {
        return this.findOneAndUpdate(filter, update, new FindOneAndUpdateOptions());
    }

    @Override
    public Publisher<T> findOneAndUpdate(Bson filter, List<? extends Bson> update, FindOneAndUpdateOptions options) {
        return this.mongoOperationPublisher.findOneAndUpdate(null, filter, update, options);
    }

    @Override
    public Publisher<T> findOneAndUpdate(ClientSession clientSession, Bson filter, List<? extends Bson> update) {
        return this.findOneAndUpdate(clientSession, filter, update, new FindOneAndUpdateOptions());
    }

    @Override
    public Publisher<T> findOneAndUpdate(ClientSession clientSession, Bson filter, List<? extends Bson> update, FindOneAndUpdateOptions options) {
        return this.mongoOperationPublisher.findOneAndUpdate((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), filter, update, options);
    }

    @Override
    public Publisher<Void> drop() {
        return this.mongoOperationPublisher.dropCollection(null, new DropCollectionOptions());
    }

    @Override
    public Publisher<Void> drop(ClientSession clientSession) {
        return this.mongoOperationPublisher.dropCollection((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), new DropCollectionOptions());
    }

    @Override
    public Publisher<Void> drop(DropCollectionOptions dropCollectionOptions) {
        return this.mongoOperationPublisher.dropCollection(null, dropCollectionOptions);
    }

    @Override
    public Publisher<Void> drop(ClientSession clientSession, DropCollectionOptions dropCollectionOptions) {
        return this.mongoOperationPublisher.dropCollection((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), dropCollectionOptions);
    }

    @Override
    public Publisher<String> createSearchIndex(String indexName, Bson definition) {
        Assertions.notNull((String)"indexName", (Object)indexName);
        Assertions.notNull((String)"definition", (Object)definition);
        return this.mongoOperationPublisher.createSearchIndex(indexName, definition);
    }

    @Override
    public Publisher<String> createSearchIndex(Bson definition) {
        Assertions.notNull((String)"definition", (Object)definition);
        return this.mongoOperationPublisher.createSearchIndex(null, definition);
    }

    @Override
    public Publisher<String> createSearchIndexes(List<SearchIndexModel> searchIndexModels) {
        Assertions.notNullElements((String)"searchIndexModels", searchIndexModels);
        return this.mongoOperationPublisher.createSearchIndexes(searchIndexModels);
    }

    @Override
    public Publisher<Void> updateSearchIndex(String indexName, Bson definition) {
        Assertions.notNull((String)"indexName", (Object)indexName);
        Assertions.notNull((String)"definition", (Object)definition);
        return this.mongoOperationPublisher.updateSearchIndex(indexName, definition);
    }

    @Override
    public Publisher<Void> dropSearchIndex(String indexName) {
        Assertions.notNull((String)"name", (Object)indexName);
        return this.mongoOperationPublisher.dropSearchIndex(indexName);
    }

    @Override
    public ListSearchIndexesPublisher<Document> listSearchIndexes() {
        return this.listSearchIndexes(Document.class);
    }

    @Override
    public <TResult> ListSearchIndexesPublisher<TResult> listSearchIndexes(Class<TResult> resultClass) {
        Assertions.notNull((String)"resultClass", resultClass);
        return new ListSearchIndexesPublisherImpl<TResult>(this.mongoOperationPublisher.withReadConcern(ReadConcern.DEFAULT).withDocumentClass(resultClass));
    }

    @Override
    public Publisher<String> createIndex(Bson key) {
        return this.createIndex(key, new IndexOptions());
    }

    @Override
    public Publisher<String> createIndex(Bson key, IndexOptions options) {
        return this.mongoOperationPublisher.createIndex(null, key, options);
    }

    @Override
    public Publisher<String> createIndex(ClientSession clientSession, Bson key) {
        return this.createIndex(clientSession, key, new IndexOptions());
    }

    @Override
    public Publisher<String> createIndex(ClientSession clientSession, Bson key, IndexOptions options) {
        return this.mongoOperationPublisher.createIndex((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), key, options);
    }

    @Override
    public Publisher<String> createIndexes(List<IndexModel> indexes) {
        return this.createIndexes(indexes, new CreateIndexOptions());
    }

    @Override
    public Publisher<String> createIndexes(List<IndexModel> indexes, CreateIndexOptions options) {
        return this.mongoOperationPublisher.createIndexes(null, indexes, options);
    }

    @Override
    public Publisher<String> createIndexes(ClientSession clientSession, List<IndexModel> indexes) {
        return this.createIndexes(clientSession, indexes, new CreateIndexOptions());
    }

    @Override
    public Publisher<String> createIndexes(ClientSession clientSession, List<IndexModel> indexes, CreateIndexOptions options) {
        return this.mongoOperationPublisher.createIndexes((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), indexes, options);
    }

    @Override
    public ListIndexesPublisher<Document> listIndexes() {
        return this.listIndexes(Document.class);
    }

    @Override
    public <TResult> ListIndexesPublisher<TResult> listIndexes(Class<TResult> resultClass) {
        return new ListIndexesPublisherImpl<TResult>(null, this.mongoOperationPublisher.withDocumentClass(resultClass));
    }

    @Override
    public ListIndexesPublisher<Document> listIndexes(ClientSession clientSession) {
        return this.listIndexes(clientSession, Document.class);
    }

    @Override
    public <TResult> ListIndexesPublisher<TResult> listIndexes(ClientSession clientSession, Class<TResult> resultClass) {
        return new ListIndexesPublisherImpl<TResult>((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), this.mongoOperationPublisher.withDocumentClass(resultClass));
    }

    @Override
    public Publisher<Void> dropIndex(String indexName) {
        return this.dropIndex(indexName, new DropIndexOptions());
    }

    @Override
    public Publisher<Void> dropIndex(Bson keys) {
        return this.dropIndex(keys, new DropIndexOptions());
    }

    @Override
    public Publisher<Void> dropIndex(String indexName, DropIndexOptions dropIndexOptions) {
        return this.mongoOperationPublisher.dropIndex(null, indexName, dropIndexOptions);
    }

    @Override
    public Publisher<Void> dropIndex(Bson keys, DropIndexOptions dropIndexOptions) {
        return this.mongoOperationPublisher.dropIndex(null, keys, dropIndexOptions);
    }

    @Override
    public Publisher<Void> dropIndex(ClientSession clientSession, String indexName) {
        return this.dropIndex(clientSession, indexName, new DropIndexOptions());
    }

    @Override
    public Publisher<Void> dropIndex(ClientSession clientSession, Bson keys) {
        return this.dropIndex(clientSession, keys, new DropIndexOptions());
    }

    @Override
    public Publisher<Void> dropIndex(ClientSession clientSession, String indexName, DropIndexOptions options) {
        return this.mongoOperationPublisher.dropIndex((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), indexName, options);
    }

    @Override
    public Publisher<Void> dropIndex(ClientSession clientSession, Bson keys, DropIndexOptions options) {
        return this.mongoOperationPublisher.dropIndex((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), keys, options);
    }

    @Override
    public Publisher<Void> dropIndexes() {
        return this.dropIndexes(new DropIndexOptions());
    }

    @Override
    public Publisher<Void> dropIndexes(DropIndexOptions options) {
        return this.mongoOperationPublisher.dropIndexes(null, options);
    }

    @Override
    public Publisher<Void> dropIndexes(ClientSession clientSession) {
        return this.dropIndexes(clientSession, new DropIndexOptions());
    }

    @Override
    public Publisher<Void> dropIndexes(ClientSession clientSession, DropIndexOptions options) {
        return this.mongoOperationPublisher.dropIndexes((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), options);
    }

    @Override
    public Publisher<Void> renameCollection(MongoNamespace newCollectionNamespace) {
        return this.renameCollection(newCollectionNamespace, new RenameCollectionOptions());
    }

    @Override
    public Publisher<Void> renameCollection(MongoNamespace newCollectionNamespace, RenameCollectionOptions options) {
        return this.mongoOperationPublisher.renameCollection(null, newCollectionNamespace, options);
    }

    @Override
    public Publisher<Void> renameCollection(ClientSession clientSession, MongoNamespace newCollectionNamespace) {
        return this.renameCollection(clientSession, newCollectionNamespace, new RenameCollectionOptions());
    }

    @Override
    public Publisher<Void> renameCollection(ClientSession clientSession, MongoNamespace newCollectionNamespace, RenameCollectionOptions options) {
        return this.mongoOperationPublisher.renameCollection((ClientSession)Assertions.notNull((String)"clientSession", (Object)clientSession), newCollectionNamespace, options);
    }
}

