/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.AggregationOptions;
import com.mongodb.MapReduceCommand;
import com.mongodb.client.model.DBCollectionCountOptions;
import com.mongodb.client.model.DBCollectionFindAndModifyOptions;
import com.mongodb.client.model.DBCollectionFindOptions;
import com.mongodb.internal.TimeoutSettings;
import java.util.concurrent.TimeUnit;

final class TimeoutSettingsHelper {
    private TimeoutSettingsHelper() {
    }

    static TimeoutSettings createTimeoutSettings(TimeoutSettings timeoutSettings, long maxTimeMS) {
        return timeoutSettings.withMaxTimeMS(maxTimeMS);
    }

    static TimeoutSettings createTimeoutSettings(TimeoutSettings timeoutSettings, long maxTimeMS, long maxAwaitTimeMS) {
        return timeoutSettings.withMaxTimeAndMaxAwaitTimeMS(maxTimeMS, maxAwaitTimeMS);
    }

    static TimeoutSettings createTimeoutSettings(TimeoutSettings timeoutSettings, AggregationOptions options) {
        return TimeoutSettingsHelper.createTimeoutSettings(timeoutSettings, options.getMaxTime(TimeUnit.MILLISECONDS));
    }

    static TimeoutSettings createTimeoutSettings(TimeoutSettings timeoutSettings, DBCollectionCountOptions options) {
        return TimeoutSettingsHelper.createTimeoutSettings(timeoutSettings, options.getMaxTime(TimeUnit.MILLISECONDS));
    }

    static TimeoutSettings createTimeoutSettings(TimeoutSettings timeoutSettings, DBCollectionFindOptions options) {
        return timeoutSettings.withMaxTimeAndMaxAwaitTimeMS(options.getMaxTime(TimeUnit.MILLISECONDS), options.getMaxAwaitTime(TimeUnit.MILLISECONDS));
    }

    static TimeoutSettings createTimeoutSettings(TimeoutSettings timeoutSettings, DBCollectionFindAndModifyOptions options) {
        return TimeoutSettingsHelper.createTimeoutSettings(timeoutSettings, options.getMaxTime(TimeUnit.MILLISECONDS));
    }

    static TimeoutSettings createTimeoutSettings(TimeoutSettings timeoutSettings, MapReduceCommand options) {
        return TimeoutSettingsHelper.createTimeoutSettings(timeoutSettings, options.getMaxTime(TimeUnit.MILLISECONDS));
    }
}

