/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.crypt.capi;

import com.mongodb.internal.crypt.capi.CAPI;
import com.mongodb.internal.crypt.capi.CAPIHelper;
import com.sun.jna.Pointer;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class CipherCallback
implements CAPI.mongocrypt_crypto_fn {
    private final String algorithm;
    private final String transformation;
    private final int mode;
    private final CipherPool cipherPool;

    CipherCallback(String algorithm, String transformation, int mode) {
        this.algorithm = algorithm;
        this.transformation = transformation;
        this.mode = mode;
        this.cipherPool = new CipherPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean crypt(Pointer ctx, CAPI.mongocrypt_binary_t key, CAPI.mongocrypt_binary_t iv, CAPI.mongocrypt_binary_t in, CAPI.mongocrypt_binary_t out, Pointer bytesWritten, CAPI.mongocrypt_status_t status) {
        Cipher cipher = null;
        try {
            IvParameterSpec ivParameterSpec = new IvParameterSpec(CAPIHelper.toByteArray(iv));
            SecretKeySpec secretKeySpec = new SecretKeySpec(CAPIHelper.toByteArray(key), this.algorithm);
            cipher = this.cipherPool.get();
            cipher.init(this.mode, (Key)secretKeySpec, ivParameterSpec);
            byte[] result = cipher.doFinal(CAPIHelper.toByteArray(in));
            CAPIHelper.writeByteArrayToBinary(out, result);
            bytesWritten.setInt(0L, result.length);
            boolean bl = true;
            if (cipher != null) {
                this.cipherPool.release(cipher);
            }
            return bl;
        }
        catch (Exception e) {
            try {
                CAPI.mongocrypt_status_set(status, 1, 0, new CAPI.cstring(e.toString()), -1);
                boolean bl = false;
                if (cipher != null) {
                    this.cipherPool.release(cipher);
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (cipher != null) {
                    this.cipherPool.release(cipher);
                }
                throw throwable;
            }
        }
    }

    private class CipherPool {
        private final ConcurrentLinkedDeque<Cipher> available = new ConcurrentLinkedDeque();

        private CipherPool() {
        }

        Cipher get() throws NoSuchAlgorithmException, NoSuchPaddingException {
            Cipher cipher = this.available.pollLast();
            if (cipher != null) {
                return cipher;
            }
            return Cipher.getInstance(CipherCallback.this.transformation);
        }

        void release(Cipher cipher) {
            this.available.addLast(cipher);
        }
    }
}

