/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.util;

import com.mongodb.LazyDBList;
import com.mongodb.LazyDBObject;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.io.RawComparator;
import org.bson.BSONCallback;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.LazyBSONCallback;
import org.bson.LazyBSONDecoder;
import org.bson.LazyBSONList;
import org.bson.LazyBSONObject;
import org.bson.types.BSONTimestamp;
import org.bson.types.BasicBSONList;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.CodeWScope;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;
import org.bson.types.Symbol;

public class BSONComparator
implements RawComparator<BSONObject> {
    private static final BSONComparator INSTANCE = new BSONComparator();
    private static final Map<Class<?>, Integer> TYPES;
    private static final LazyBSONDecoder DECODER;

    public static BSONComparator getInstance() {
        return INSTANCE;
    }

    private Iterator<Map.Entry<String, Object>> getIterator(BSONObject obj) {
        if (obj instanceof BasicBSONObject) {
            return ((BasicBSONObject)obj).entrySet().iterator();
        }
        return ((LazyBSONObject)obj).entrySet().iterator();
    }

    private int compareValues(Object one, Object two) {
        int diff = 0;
        if (one instanceof Number) {
            diff = Double.valueOf(one.toString()).compareTo(Double.valueOf(two.toString()));
        } else if (one instanceof String) {
            diff = ((String)one).compareTo((String)two);
        } else if (one instanceof BSONObject) {
            diff = this.compare((BSONObject)one, (BSONObject)two);
        } else if (one instanceof Binary) {
            ByteBuffer buff1 = ByteBuffer.wrap(((Binary)one).getData());
            ByteBuffer buff2 = ByteBuffer.wrap(((Binary)two).getData());
            diff = buff1.compareTo(buff2);
        } else if (one instanceof byte[]) {
            ByteBuffer buff1 = ByteBuffer.wrap((byte[])one);
            ByteBuffer buff2 = ByteBuffer.wrap((byte[])two);
            diff = buff1.compareTo(buff2);
        } else if (one instanceof ObjectId) {
            diff = ((ObjectId)one).compareTo((ObjectId)two);
        } else if (one instanceof Boolean) {
            diff = ((Boolean)one).compareTo((Boolean)two);
        } else if (one instanceof Date) {
            diff = ((Date)one).compareTo((Date)two);
        } else if (one instanceof BSONTimestamp) {
            diff = ((BSONTimestamp)one).compareTo((BSONTimestamp)two);
        }
        return diff;
    }

    public int compare(BSONObject obj1, BSONObject obj2) {
        Iterator<Map.Entry<String, Object>> iter1 = this.getIterator(obj1);
        Iterator<Map.Entry<String, Object>> iter2 = this.getIterator(obj2);
        while (iter1.hasNext()) {
            Integer twoValue;
            if (!iter2.hasNext()) {
                return -1;
            }
            Map.Entry<String, Object> entry1 = iter1.next();
            Map.Entry<String, Object> entry2 = iter2.next();
            int diff = entry1.getKey().compareTo(entry2.getKey());
            if (diff != 0) {
                return diff;
            }
            Object one = entry1.getValue();
            Object two = entry2.getValue();
            if (one == null && two == null) continue;
            if (one == null) {
                return -1;
            }
            if (two == null) {
                return 1;
            }
            Integer oneValue = TYPES.get(one.getClass());
            diff = oneValue.compareTo(twoValue = TYPES.get(two.getClass()));
            if (diff != 0) {
                return diff;
            }
            diff = this.compareValues(one, two);
            if (diff == 0) continue;
            return diff;
        }
        if (iter2.hasNext()) {
            return 1;
        }
        return 0;
    }

    public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        LazyBSONCallback cb = new LazyBSONCallback();
        DECODER.decode(b1, (BSONCallback)cb);
        BSONObject a = (BSONObject)cb.get();
        cb.reset();
        DECODER.decode(b2, (BSONCallback)cb);
        BSONObject b = (BSONObject)cb.get();
        return this.compare(a, b);
    }

    static {
        HashMap aType = new HashMap();
        aType.put(MinKey.class, 1);
        aType.put(null, 2);
        aType.put(Integer.class, 3);
        aType.put(Double.class, 3);
        aType.put(Float.class, 3);
        aType.put(String.class, 4);
        aType.put(Symbol.class, 4);
        aType.put(LazyBSONObject.class, 5);
        aType.put(BasicBSONObject.class, 5);
        aType.put(LazyDBObject.class, 5);
        aType.put(LazyDBList.class, 6);
        aType.put(LazyBSONList.class, 6);
        aType.put(BasicBSONList.class, 6);
        aType.put(Binary.class, 7);
        aType.put(byte[].class, 7);
        aType.put(ObjectId.class, 8);
        aType.put(Boolean.class, 9);
        aType.put(Date.class, 10);
        aType.put(BSONTimestamp.class, 10);
        aType.put(Pattern.class, 11);
        aType.put(Code.class, 13);
        aType.put(CodeWScope.class, 13);
        aType.put(MaxKey.class, 12);
        TYPES = aType;
        DECODER = new LazyBSONDecoder();
    }
}

