/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.splitter;

import com.mongodb.MongoClientURI;
import com.mongodb.hadoop.input.MongoInputSplit;
import com.mongodb.hadoop.splitter.MongoCollectionSplitter;
import com.mongodb.hadoop.util.MongoConfigUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;

public class SingleMongoSplitter
extends MongoCollectionSplitter {
    private static final Log LOG = LogFactory.getLog(SingleMongoSplitter.class);

    public SingleMongoSplitter() {
    }

    public SingleMongoSplitter(Configuration conf) {
        super(conf);
    }

    @Override
    public List<InputSplit> calculateSplits() {
        this.init();
        MongoClientURI inputURI = MongoConfigUtil.getInputURI(this.conf);
        LOG.info((Object)("SingleMongoSplitter calculating splits for " + inputURI));
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        MongoInputSplit mongoSplit = new MongoInputSplit();
        mongoSplit.setInputURI(MongoConfigUtil.getInputURI(this.conf));
        mongoSplit.setAuthURI(MongoConfigUtil.getAuthURI(this.conf));
        mongoSplit.setQuery(MongoConfigUtil.getQuery(this.conf));
        mongoSplit.setNoTimeout(MongoConfigUtil.isNoTimeout(this.conf));
        mongoSplit.setFields(MongoConfigUtil.getFields(this.conf));
        mongoSplit.setSort(MongoConfigUtil.getSort(this.conf));
        splits.add(mongoSplit);
        return splits;
    }
}

