/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.splitter;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.MongoClientURI;
import com.mongodb.hadoop.input.MongoInputSplit;
import com.mongodb.hadoop.splitter.MongoCollectionSplitter;
import com.mongodb.hadoop.splitter.SplitFailedException;
import com.mongodb.hadoop.util.MongoConfigUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;

public class ShardChunkMongoSplitter
extends MongoCollectionSplitter {
    private static final Log LOG = LogFactory.getLog(ShardChunkMongoSplitter.class);

    public ShardChunkMongoSplitter(Configuration conf) {
        super(conf);
    }

    @Override
    public List<InputSplit> calculateSplits() throws SplitFailedException {
        this.init();
        boolean targetShards = MongoConfigUtil.canReadSplitsFromShards(this.conf);
        DB configDB = this.mongo.getDB("config");
        DBCollection chunksCollection = configDB.getCollection("chunks");
        MongoClientURI inputURI = MongoConfigUtil.getInputURI(this.conf);
        String inputNS = inputURI.getDatabase() + "." + inputURI.getCollection();
        DBCursor cur = chunksCollection.find(new BasicDBObject("ns", inputNS));
        int numChunks = 0;
        Map<String, String> shardsMap = null;
        if (targetShards) {
            try {
                shardsMap = this.getShardsMap();
            }
            catch (Exception e) {
                throw new SplitFailedException("Couldn't get shards information from config server", e);
            }
        }
        List<String> mongosHostNames = MongoConfigUtil.getInputMongosHosts(this.conf);
        if (targetShards && mongosHostNames.size() > 0) {
            throw new SplitFailedException("Setting both mongo.input.split.read_from_shards and mongo.input.mongos_hosts does not make sense. ");
        }
        if (mongosHostNames.size() > 0) {
            LOG.info((Object)"Using multiple mongos instances (round robin) for reading input.");
        }
        HashMap<String, LinkedList<MongoInputSplit>> shardToSplits = new HashMap<String, LinkedList<MongoInputSplit>>();
        while (cur.hasNext()) {
            MongoClientURI newURI;
            BasicDBObject row = (BasicDBObject)cur.next();
            BasicDBObject chunkLowerBound = (BasicDBObject)row.get("min");
            BasicDBObject chunkUpperBound = (BasicDBObject)row.get("max");
            MongoInputSplit chunkSplit = this.createSplitFromBounds(chunkLowerBound, chunkUpperBound);
            chunkSplit.setInputURI(inputURI);
            String shard = (String)row.get("shard");
            if (targetShards) {
                String shardHosts = shardsMap.get(shard);
                if (shardHosts == null) {
                    throw new SplitFailedException("Couldn't find shard ID: " + shard + " in config.shards.");
                }
                newURI = ShardChunkMongoSplitter.rewriteURI(inputURI, shardHosts);
                chunkSplit.setInputURI(newURI);
            } else if (mongosHostNames.size() > 0) {
                String roundRobinHost = mongosHostNames.get(numChunks % mongosHostNames.size());
                newURI = ShardChunkMongoSplitter.rewriteURI(inputURI, roundRobinHost);
                chunkSplit.setInputURI(newURI);
            }
            LinkedList<MongoInputSplit> shardList = (LinkedList<MongoInputSplit>)shardToSplits.get(shard);
            if (shardList == null) {
                shardList = new LinkedList<MongoInputSplit>();
                shardToSplits.put(shard, shardList);
            }
            shardList.add(chunkSplit);
            ++numChunks;
        }
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>(numChunks);
        int splitIndex = 0;
        while (splitIndex < numChunks) {
            HashSet shardSplitsToRemove = new HashSet();
            for (Map.Entry shardSplits : shardToSplits.entrySet()) {
                LinkedList shardSplitsList = (LinkedList)shardSplits.getValue();
                InputSplit split = (InputSplit)shardSplitsList.pop();
                splits.add(splitIndex, split);
                ++splitIndex;
                if (!shardSplitsList.isEmpty()) continue;
                shardSplitsToRemove.add(shardSplits.getKey());
            }
            for (String shardName : shardSplitsToRemove) {
                shardToSplits.remove(shardName);
            }
        }
        return splits;
    }
}

