/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.splitter;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoClientURI;
import com.mongodb.hadoop.input.MongoInputSplit;
import com.mongodb.hadoop.splitter.MongoSplitter;
import com.mongodb.hadoop.splitter.SplitFailedException;
import com.mongodb.hadoop.util.MongoConfigUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.bson.BSONObject;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;

public abstract class MongoCollectionSplitter
extends MongoSplitter {
    private static final Log LOG = LogFactory.getLog(MongoCollectionSplitter.class);
    public static final MinKey MIN_KEY_TYPE = new MinKey();
    public static final MaxKey MAX_KEY_TYPE = new MaxKey();
    protected Mongo mongo;
    protected DBCollection inputCollection;
    protected DB authDB;

    public MongoCollectionSplitter() {
    }

    public MongoCollectionSplitter(Configuration conf) {
        super(conf);
    }

    protected void init() {
        MongoClientURI inputURI = MongoConfigUtil.getInputURI(this.conf);
        this.inputCollection = MongoConfigUtil.getCollection(inputURI);
        DB db = this.inputCollection.getDB();
        this.mongo = db.getMongo();
        MongoClientURI authURI = MongoConfigUtil.getAuthURI(this.conf);
        if (authURI != null && authURI.getUsername() != null && authURI.getPassword() != null) {
            this.authDB = this.mongo.getDB(authURI.getDatabase());
        }
    }

    @Override
    public abstract List<InputSplit> calculateSplits() throws SplitFailedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> getShardsMap() {
        DB configDB = this.mongo.getDB("config");
        HashMap<String, String> shardsMap = new HashMap<String, String>();
        DBCollection shardsCollection = configDB.getCollection("shards");
        DBCursor cur = shardsCollection.find();
        try {
            while (cur.hasNext()) {
                BasicDBObject row = (BasicDBObject)cur.next();
                String host = row.getString("host");
                int slashIndex = host.indexOf(47);
                if (slashIndex > 0) {
                    host = host.substring(slashIndex + 1);
                }
                shardsMap.put((String)row.get("_id"), host);
            }
        }
        finally {
            cur.close();
        }
        return shardsMap;
    }

    protected static MongoClientURI rewriteURI(MongoClientURI originalUri, String newServerUri) {
        String originalUriString = originalUri.toString();
        int idx = (originalUriString = originalUriString.substring("mongodb://".length())).lastIndexOf("/");
        int serverEnd = idx < 0 ? originalUriString.length() : idx;
        idx = originalUriString.indexOf("@");
        int serverStart = idx > 0 ? idx + 1 : 0;
        StringBuilder sb = new StringBuilder(originalUriString);
        sb.replace(serverStart, serverEnd, newServerUri);
        String ans = "mongodb://" + sb.toString();
        return new MongoClientURI(ans);
    }

    public MongoInputSplit createSplitFromBounds(BasicDBObject lowerBound, BasicDBObject upperBound) throws SplitFailedException {
        Object val;
        String key;
        LOG.info((Object)("Created split: min=" + (lowerBound != null ? lowerBound.toString() : "null") + ", max= " + (upperBound != null ? upperBound.toString() : "null")));
        BasicDBObject splitMin = new BasicDBObject();
        BasicDBObject splitMax = new BasicDBObject();
        if (lowerBound != null) {
            for (Map.Entry entry : lowerBound.entrySet()) {
                key = (String)entry.getKey();
                val = entry.getValue();
                if (val.equals(MIN_KEY_TYPE)) continue;
                splitMin.put(key, val);
            }
        }
        if (upperBound != null) {
            for (Map.Entry entry : upperBound.entrySet()) {
                key = (String)entry.getKey();
                val = entry.getValue();
                if (val.equals(MAX_KEY_TYPE)) continue;
                splitMax.put(key, val);
            }
        }
        MongoInputSplit split = null;
        DBObject query = MongoConfigUtil.getQuery(this.conf);
        if (MongoConfigUtil.isRangeQueryEnabled(this.conf)) {
            try {
                query = MongoConfigUtil.getQuery(this.conf);
                split = this.createRangeQuerySplit(lowerBound, upperBound, query);
            }
            catch (Exception e) {
                throw new SplitFailedException("Couldn't use range query to create split: " + e.getMessage());
            }
        }
        if (split == null) {
            split = new MongoInputSplit();
            BasicDBObject splitQuery = new BasicDBObject();
            if (query != null) {
                splitQuery.putAll(query);
            }
            split.setQuery(splitQuery);
            split.setMin(splitMin);
            split.setMax(splitMax);
        }
        split.setInputURI(MongoConfigUtil.getInputURI(this.conf));
        split.setAuthURI(MongoConfigUtil.getAuthURI(this.conf));
        split.setNoTimeout(MongoConfigUtil.isNoTimeout(this.conf));
        split.setFields(MongoConfigUtil.getFields(this.conf));
        split.setSort(MongoConfigUtil.getSort(this.conf));
        return split;
    }

    public MongoInputSplit createRangeQuerySplit(BasicDBObject chunkLowerBound, BasicDBObject chunkUpperBound, BSONObject query) {
        Map.Entry maxKey;
        if (chunkLowerBound == null && chunkUpperBound == null) {
            BasicDBObject splitQuery = new BasicDBObject();
            splitQuery.putAll(query);
            MongoInputSplit split = new MongoInputSplit();
            split.setQuery(splitQuery);
            return split;
        }
        Map.Entry minKey = chunkLowerBound != null && chunkLowerBound.keySet().size() == 1 ? chunkLowerBound.entrySet().iterator().next() : null;
        Map.Entry entry = maxKey = chunkUpperBound != null && chunkUpperBound.keySet().size() == 1 ? chunkUpperBound.entrySet().iterator().next() : null;
        if (minKey == null && maxKey == null) {
            throw new IllegalArgumentException("Range query is enabled but one or more split boundaries contains a compound key:\nmin:  " + chunkLowerBound + "\nmax:  " + chunkUpperBound);
        }
        if (minKey != null && query.containsField((String)minKey.getKey()) || maxKey != null && query.containsField((String)maxKey.getKey())) {
            throw new IllegalArgumentException("Range query is enabled but split key conflicts with query filter:\nmin:  " + chunkLowerBound + "\nmax:  " + chunkUpperBound + "\nquery:  " + query);
        }
        String key = null;
        BasicDBObject rangeObj = new BasicDBObject();
        if (minKey != null) {
            key = (String)minKey.getKey();
            rangeObj.put("$gte", minKey.getValue());
        }
        if (maxKey != null) {
            key = (String)maxKey.getKey();
            rangeObj.put("$lt", maxKey.getValue());
        }
        BasicDBObject splitQuery = new BasicDBObject();
        splitQuery.putAll(query);
        splitQuery.put(key, (Object)rangeObj);
        MongoInputSplit split = new MongoInputSplit();
        split.setQuery(splitQuery);
        return split;
    }
}

