/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.splitter;

import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.bson.BSONCallback;
import org.bson.BSONObject;
import org.bson.BasicBSONCallback;
import org.bson.BasicBSONDecoder;
import org.bson.BasicBSONEncoder;
import org.bson.LazyBSONCallback;
import org.bson.LazyBSONDecoder;
import org.bson.LazyBSONObject;

public class BSONSplitter
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(BSONSplitter.class);
    private ArrayList<FileSplit> splitsList;
    private Path inputPath;
    private BasicBSONCallback callback = new BasicBSONCallback();
    private LazyBSONCallback lazyCallback = new LazyBSONCallback();
    private LazyBSONDecoder lazyDec = new LazyBSONDecoder();
    private BasicBSONDecoder bsonDec = new BasicBSONDecoder();
    private BasicBSONEncoder bsonEnc = new BasicBSONEncoder();

    public void setInputPath(Path p) {
        this.inputPath = p;
    }

    public ArrayList<FileSplit> getAllSplits() {
        if (this.splitsList == null) {
            return new ArrayList<FileSplit>(0);
        }
        return this.splitsList;
    }

    public FileSplit createFileSplitFromBSON(BSONObject obj, FileSystem fs, FileStatus inputFile) throws IOException {
        long start = (Long)obj.get("s");
        long splitLen = (Long)obj.get("l");
        try {
            BlockLocation[] blkLocations = fs.getFileBlockLocations(inputFile, start, splitLen);
            int blockIndex = BSONSplitter.getLargestBlockIndex(blkLocations);
            return new FileSplit(inputFile.getPath(), start, splitLen, blkLocations[blockIndex].getHosts());
        }
        catch (IOException e) {
            LOG.warn((Object)("Couldn't find block locations when constructing input split from BSON. Using non-block-aware input split; " + e.getMessage()));
            return new FileSplit(inputFile.getPath(), start, splitLen, null);
        }
    }

    public FileSplit createFileSplit(FileStatus inFile, FileSystem fs, long splitStart, long splitLen) {
        try {
            BlockLocation[] blkLocations = fs.getFileBlockLocations(inFile, splitStart, splitLen);
            int blockIndex = BSONSplitter.getLargestBlockIndex(blkLocations);
            return new FileSplit(inFile.getPath(), splitStart, splitLen, blkLocations[blockIndex].getHosts());
        }
        catch (IOException e) {
            LOG.warn((Object)("Couldn't find block locations when constructing input split from byte offset. Using non-block-aware input split; " + e.getMessage()));
            return new FileSplit(inFile.getPath(), splitStart, splitLen, null);
        }
    }

    public void loadSplitsFromSplitFile(FileStatus inputFile, Path splitFile) throws NoSplitFileException, IOException {
        FileStatus splitFileStatus;
        ArrayList<FileSplit> splits = new ArrayList<FileSplit>();
        FileSystem fs = splitFile.getFileSystem(this.getConf());
        try {
            splitFileStatus = fs.getFileStatus(splitFile);
            LOG.info((Object)("Found split file at : " + splitFileStatus));
        }
        catch (Exception e) {
            throw new NoSplitFileException();
        }
        FSDataInputStream fsDataStream = fs.open(splitFile);
        while (fsDataStream.getPos() < splitFileStatus.getLen()) {
            this.callback.reset();
            this.bsonDec.decode((InputStream)fsDataStream, (BSONCallback)this.callback);
            BSONObject splitInfo = (BSONObject)this.callback.get();
            splits.add(this.createFileSplitFromBSON(splitInfo, fs, inputFile));
        }
        this.splitsList = splits;
    }

    public static long getSplitSize(Configuration conf, FileStatus file) {
        long minSize = Math.max(1L, conf.getLong("mapred.min.split.size", 1L));
        long maxSize = conf.getLong("mapred.max.split.size", Long.MAX_VALUE);
        if (file != null) {
            long fileBlockSize = file.getBlockSize();
            return Math.max(minSize, Math.min(maxSize, fileBlockSize));
        }
        long blockSize = conf.getLong("dfs.blockSize", 0x4000000L);
        return Math.max(minSize, Math.min(maxSize, blockSize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readSplitsForFile(FileStatus file) throws IOException {
        Path path = file.getPath();
        ArrayList<FileSplit> splits = new ArrayList<FileSplit>();
        FileSystem fs = path.getFileSystem(this.getConf());
        long length = file.getLen();
        if (!this.getConf().getBoolean("bson.split.read_splits", true)) {
            LOG.info((Object)("Reading splits is disabled - constructing single split for " + file));
            FileSplit onesplit = this.createFileSplit(file, fs, 0L, length);
            splits.add(onesplit);
            this.splitsList = splits;
            return;
        }
        if (length != 0L) {
            int numDocsRead = 0;
            long splitSize = BSONSplitter.getSplitSize(this.getConf(), file);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Generating splits for " + path + " of up to " + splitSize + " bytes."));
            }
            FSDataInputStream fsDataStream = fs.open(path);
            long curSplitLen = 0L;
            long curSplitStart = 0L;
            try {
                while (fsDataStream.getPos() + 1L < length) {
                    this.lazyCallback.reset();
                    this.lazyDec.decode((InputStream)fsDataStream, (BSONCallback)this.lazyCallback);
                    LazyBSONObject bo = (LazyBSONObject)this.lazyCallback.get();
                    int bsonDocSize = bo.getBSONSize();
                    if (curSplitLen + (long)bsonDocSize >= splitSize) {
                        FileSplit split = this.createFileSplit(file, fs, curSplitStart, curSplitLen);
                        splits.add(split);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)String.format("Creating new split (%d) %s", splits.size(), split));
                        }
                        curSplitStart = fsDataStream.getPos() - (long)bsonDocSize;
                        curSplitLen = 0L;
                    }
                    curSplitLen += (long)bsonDocSize;
                    if (++numDocsRead % 1000 != 0) continue;
                    float splitProgress = 100.0f * ((float)fsDataStream.getPos() / (float)length);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)String.format("Read %d docs calculating splits for %s; %3.3f%% complete.", numDocsRead, file.getPath(), Float.valueOf(splitProgress)));
                }
                if (curSplitLen > 0L) {
                    FileSplit split = this.createFileSplit(file, fs, curSplitStart, curSplitLen);
                    splits.add(split);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)String.format("Final split (%d) %s", splits.size(), split.getPath()));
                    }
                }
                this.splitsList = splits;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Completed splits calculation for " + file.getPath()));
                }
                this.writeSplits();
            }
            catch (IOException e) {
                LOG.warn((Object)("IOException: " + e));
            }
            finally {
                fsDataStream.close();
            }
        } else {
            LOG.warn((Object)"Zero-length file, skipping split calculation.");
        }
    }

    public void writeSplits() throws IOException {
        if (!this.getConf().getBoolean("bson.split.write_splits", true)) {
            LOG.info((Object)"bson.split.write_splits is set to false - skipping writing splits to disk.");
            return;
        }
        LOG.info((Object)"Writing splits to disk.");
        if (this.splitsList == null) {
            LOG.info((Object)"No splits found, skipping write of splits file.");
        }
        Path outputPath = new Path(this.inputPath.getParent(), "." + this.inputPath.getName() + ".splits");
        FileSystem pathFileSystem = outputPath.getFileSystem(this.getConf());
        FSDataOutputStream fsDataOut = null;
        try {
            fsDataOut = pathFileSystem.create(outputPath, false);
            for (FileSplit inputSplit : this.splitsList) {
                DBObject splitObj = BasicDBObjectBuilder.start().add("s", inputSplit.getStart()).add("l", inputSplit.getLength()).get();
                byte[] encodedObj = this.bsonEnc.encode(splitObj);
                fsDataOut.write(encodedObj, 0, encodedObj.length);
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Could not create splits file: " + e.getMessage()));
            throw e;
        }
        finally {
            if (fsDataOut != null) {
                fsDataOut.close();
            }
        }
    }

    public void readSplits() throws IOException {
        this.splitsList = new ArrayList();
        if (this.inputPath == null) {
            throw new IllegalStateException("Input path has not been set.");
        }
        FileSystem fs = this.inputPath.getFileSystem(this.getConf());
        FileStatus file = fs.getFileStatus(this.inputPath);
        this.readSplitsForFile(file);
    }

    public int run(String[] args) throws Exception {
        this.setInputPath(new Path(this.getConf().get("mapred.input.dir", "")));
        this.readSplits();
        this.writeSplits();
        return 0;
    }

    public static int getLargestBlockIndex(BlockLocation[] blockLocations) {
        int retVal = -1;
        if (blockLocations == null) {
            return retVal;
        }
        long max = 0L;
        for (int i = 0; i < blockLocations.length; ++i) {
            BlockLocation blk = blockLocations[i];
            if (blk.getLength() <= max) continue;
            retVal = i;
        }
        return retVal;
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run((Tool)new BSONSplitter(), (String[])args));
    }

    public static class NoSplitFileException
    extends Exception {
    }
}

