/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.pig;

import com.mongodb.hadoop.MongoOutputFormat;
import com.mongodb.hadoop.io.MongoUpdateWritable;
import com.mongodb.hadoop.output.MongoRecordWriter;
import com.mongodb.hadoop.pig.JSONPigReplace;
import com.mongodb.hadoop.util.MongoConfigUtil;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.StoreFunc;
import org.apache.pig.StoreMetadata;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.impl.util.Utils;
import org.bson.BasicBSONObject;

public class MongoUpdateStorage
extends StoreFunc
implements StoreMetadata {
    private static final Log LOG = LogFactory.getLog(MongoUpdateStorage.class);
    static final String SCHEMA_SIGNATURE = "mongoupdate.pig.output.schema";
    protected ResourceSchema schema = null;
    private String udfcSignature = null;
    private final MongoOutputFormat outputFormat = new MongoOutputFormat();
    private MongoRecordWriter<?, MongoUpdateWritable> recordWriter = null;
    private JSONPigReplace repl;
    private String schemaStr;
    private String unnamedStr;

    public MongoUpdateStorage(String query, String update) {
        this.repl = new JSONPigReplace(new String[]{query, update});
    }

    public MongoUpdateStorage(String query, String update, String s) {
        this(query, update);
        this.schemaStr = s;
    }

    public MongoUpdateStorage(String query, String update, String s, String toIgnore) {
        this(query, update, s);
        this.unnamedStr = toIgnore.length() > 0 ? toIgnore : null;
    }

    public MongoUpdateStorage(String query, String update, String s, String toIgnore, String updateOptions) {
        this.repl = new JSONPigReplace(new String[]{query, update, updateOptions});
        this.schemaStr = s;
        this.unnamedStr = toIgnore.length() > 0 ? toIgnore : null;
    }

    public void checkSchema(ResourceSchema s) throws IOException {
        this.schema = s;
        UDFContext udfc = UDFContext.getUDFContext();
        Properties p = udfc.getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.udfcSignature});
        p.setProperty(SCHEMA_SIGNATURE, this.schema.toString());
    }

    public void storeSchema(ResourceSchema schema, String location, Job job) {
    }

    public void storeStatistics(ResourceStatistics stats, String location, Job job) {
    }

    public void putNext(Tuple tuple) throws IOException {
        try {
            BasicBSONObject mu;
            BasicBSONObject[] toUpdate = this.repl.substitute(tuple, this.schema, this.unnamedStr);
            BasicBSONObject q = toUpdate[0];
            BasicBSONObject u = toUpdate[1];
            boolean isUpsert = true;
            boolean isMulti = false;
            BasicBSONObject basicBSONObject = mu = toUpdate.length > 2 ? toUpdate[2] : null;
            if (mu != null) {
                isUpsert = !mu.containsField("upsert") || mu.getBoolean("upsert");
                isMulti = mu.containsField("multi") && mu.getBoolean("multi");
            }
            this.recordWriter.write(null, new MongoUpdateWritable(q, u, isUpsert, isMulti));
        }
        catch (Exception e) {
            throw new IOException("Couldn't convert tuple to bson: ", e);
        }
    }

    public void prepareToWrite(RecordWriter writer) throws IOException {
        this.recordWriter = (MongoRecordWriter)writer;
        LOG.info((Object)("Preparing to write to " + this.recordWriter));
        if (this.recordWriter == null) {
            throw new IOException("Invalid Record Writer");
        }
        UDFContext udfc = UDFContext.getUDFContext();
        Properties p = udfc.getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.udfcSignature});
        if (this.schemaStr != null) {
            try {
                this.schema = new ResourceSchema(Utils.getSchemaFromString((String)this.schemaStr));
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            String s = p.getProperty(SCHEMA_SIGNATURE);
            if (s == null) {
                throw new IOException("Could not find schema in UDF context. You'd have to explicitly specify a Schema.");
            }
            this.schema = new ResourceSchema(Utils.getSchemaFromString((String)s));
        }
    }

    public OutputFormat getOutputFormat() throws IOException {
        return this.outputFormat;
    }

    public String relToAbsPathForStoreLocation(String location, Path curDir) throws IOException {
        return location;
    }

    public void setStoreLocation(String location, Job job) throws IOException {
        Configuration config = job.getConfiguration();
        LOG.info((Object)("Store Location Config: " + config + "; For URI: " + location));
        if (!location.startsWith("mongodb://")) {
            throw new IllegalArgumentException("Invalid URI Format.  URIs must begin with a mongodb:// protocol string.");
        }
        MongoConfigUtil.setOutputURI(config, location);
    }

    public void setStoreFuncUDFContextSignature(String signature) {
        this.udfcSignature = signature;
    }
}

