/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.pig;

import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.hadoop.MongoOutputFormat;
import com.mongodb.hadoop.pig.BSONStorage;
import com.mongodb.hadoop.pig.MongoStorage;
import com.mongodb.hadoop.util.MongoConfigUtil;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.StoreFunc;
import org.apache.pig.StoreMetadata;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.impl.util.Utils;

public class MongoInsertStorage
extends StoreFunc
implements StoreMetadata {
    private static final Log LOG = LogFactory.getLog(MongoStorage.class);
    static final String SCHEMA_SIGNATURE = "mongoinsert.pig.output.schema";
    protected ResourceSchema schema = null;
    private RecordWriter out;
    private String udfcSignature = null;
    private String idField = null;
    private final MongoOutputFormat outputFormat = new MongoOutputFormat();

    public MongoInsertStorage() {
    }

    public MongoInsertStorage(String idField, String useUpsert) {
        this.idField = idField;
    }

    protected void writeField(BasicDBObjectBuilder builder, ResourceSchema.ResourceFieldSchema field, Object d) throws IOException {
        Object convertedType = BSONStorage.getTypeForBSON(d, field, null);
        if (field.getName() != null && field.getName().equals(this.idField)) {
            builder.add("_id", convertedType);
        } else {
            builder.add(field.getName(), convertedType);
        }
    }

    public void checkSchema(ResourceSchema schema) throws IOException {
        this.schema = schema;
        UDFContext udfc = UDFContext.getUDFContext();
        Properties p = udfc.getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.udfcSignature});
        p.setProperty(SCHEMA_SIGNATURE, schema.toString());
    }

    public void storeSchema(ResourceSchema schema, String location, Job job) {
    }

    public void storeStatistics(ResourceStatistics stats, String location, Job job) {
    }

    public void putNext(Tuple tuple) throws IOException {
        try {
            BasicDBObjectBuilder builder = BasicDBObjectBuilder.start();
            ResourceSchema.ResourceFieldSchema[] fields = null;
            if (this.schema != null) {
                fields = this.schema.getFields();
            }
            if (fields != null) {
                for (int i = 0; i < fields.length; ++i) {
                    this.writeField(builder, fields[i], tuple.get(i));
                }
            } else {
                for (int i = 0; i < tuple.size(); ++i) {
                    this.writeField(builder, null, tuple.get(i));
                }
            }
            this.out.write(null, (Object)builder.get());
        }
        catch (Exception e) {
            throw new IOException("Couldn't convert tuple to bson: ", e);
        }
    }

    public void prepareToWrite(RecordWriter writer) throws IOException {
        this.out = writer;
        if (this.out == null) {
            throw new IOException("Invalid Record Writer");
        }
        UDFContext udfc = UDFContext.getUDFContext();
        Properties p = udfc.getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.udfcSignature});
        String strSchema = p.getProperty(SCHEMA_SIGNATURE);
        if (strSchema == null) {
            throw new IOException("Could not find schema in UDF context");
        }
        try {
            this.schema = new ResourceSchema(Utils.getSchemaFromString((String)strSchema));
        }
        catch (Exception e) {
            this.schema = null;
            LOG.warn((Object)e.getMessage());
        }
        LOG.info((Object)("GOT A SCHEMA " + this.schema + " " + strSchema));
    }

    public OutputFormat getOutputFormat() throws IOException {
        return this.outputFormat;
    }

    public String relToAbsPathForStoreLocation(String location, Path curDir) throws IOException {
        return location;
    }

    public void setStoreLocation(String location, Job job) throws IOException {
        Configuration config = job.getConfiguration();
        LOG.info((Object)("Store Location Config: " + config + " For URI: " + location));
        if (!location.startsWith("mongodb://")) {
            throw new IllegalArgumentException("Invalid URI Format.  URIs must begin with a mongodb:// protocol string.");
        }
        MongoConfigUtil.setOutputURI(config, location);
    }

    public void setStoreFuncUDFContextSignature(String signature) {
        this.udfcSignature = signature;
    }
}

