/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.pig;

import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.hadoop.pig.BSONStorage;
import com.mongodb.util.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.Utils;
import org.bson.BasicBSONObject;

public class JSONPigReplace {
    private static final Log LOG = LogFactory.getLog(JSONPigReplace.class);
    private final BasicBSONObject[] initBSONs;
    private String unnamedStr;
    private HashMap<String, Object> reps;

    public JSONPigReplace(String[] str) {
        this.initBSONs = new BasicBSONObject[str.length];
        this.reps = new HashMap();
        for (int i = 0; i < str.length; ++i) {
            this.initBSONs[i] = (BasicBSONObject)JSON.parse(str[i]);
            try {
                Matcher m = Pattern.compile("\\$(\\w+)").matcher(str[i]);
                while (m.find()) {
                    this.reps.put(m.group(1), null);
                }
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)"Error while extracting strings to replace");
            }
        }
    }

    public BasicBSONObject[] substitute(Tuple t, Object s, String un) throws Exception {
        ResourceSchema.ResourceFieldSchema[] fields;
        this.unnamedStr = un;
        try {
            ResourceSchema schema;
            if (s instanceof String) {
                schema = new ResourceSchema(Utils.getSchemaFromString((String)((String)s)));
            } else if (s instanceof Schema) {
                schema = new ResourceSchema((Schema)s);
            } else if (s instanceof ResourceSchema) {
                schema = (ResourceSchema)s;
            } else {
                throw new IllegalArgumentException("Schema must be represented either by a string or a Schema object");
            }
            fields = schema.getFields();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid Schema Format");
        }
        BasicDBObjectBuilder builder = BasicDBObjectBuilder.start();
        for (int i = 0; i < fields.length; ++i) {
            this.writeField(builder, fields[i], t.get(i));
        }
        BasicBSONObject pObj = (BasicBSONObject)((Object)builder.get());
        this.fillReplacementMap(pObj);
        return JSONPigReplace.replaceAll(this.initBSONs, this.reps);
    }

    private void fillReplacementMap(Object pObj) throws IOException {
        block4: {
            block3: {
                if (!(pObj instanceof BasicBSONObject) && !(pObj instanceof Map)) break block3;
                Map p = (Map)pObj;
                for (String k : p.keySet()) {
                    Object val = p.get(k);
                    if (this.reps.containsKey(k)) {
                        this.reps.put(k, val);
                        continue;
                    }
                    if (!(val instanceof BasicBSONObject) && !(val instanceof ArrayList)) continue;
                    this.fillReplacementMap(val);
                }
                break block4;
            }
            if (!(pObj instanceof ArrayList)) break block4;
            for (Object o : (ArrayList)pObj) {
                this.fillReplacementMap(o);
            }
        }
    }

    public static BasicBSONObject[] replaceAll(BasicBSONObject[] ins, Map<String, Object> reps) {
        BasicBSONObject[] res = new BasicBSONObject[ins.length];
        for (int i = 0; i < res.length; ++i) {
            try {
                res[i] = JSONPigReplace.replaceAll(ins[i], reps);
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return res;
    }

    public static BasicBSONObject replaceAll(BasicBSONObject in, Map<String, Object> reps) {
        if (in == null) {
            throw new IllegalArgumentException("JSON/BasicBSONObject to make substitutions in cannot be null!");
        }
        BasicBSONObject res = new BasicBSONObject();
        for (Map.Entry e : in.entrySet()) {
            String k = (String)e.getKey();
            Object v = e.getValue();
            if (v instanceof BasicBSONObject) {
                res.put(k, (Object)JSONPigReplace.replaceAll((BasicBSONObject)v, reps));
                continue;
            }
            if (v instanceof String && ((String)v).startsWith("$")) {
                res.put(k, reps.get(((String)v).substring(1)));
                continue;
            }
            res.put(k, v);
        }
        return res;
    }

    private void writeField(BasicDBObjectBuilder builder, ResourceSchema.ResourceFieldSchema field, Object d) throws Exception {
        if (field == null) {
            throw new IllegalArgumentException("Top-level fields should have a name");
        }
        Object convertedType = BSONStorage.getTypeForBSON(d, field, this.unnamedStr);
        if (convertedType instanceof Map) {
            for (Map.Entry entry : ((Map)convertedType).entrySet()) {
                builder.add((String)entry.getKey(), entry.getValue());
            }
        } else {
            builder.add(field.getName(), convertedType);
        }
    }
}

