/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.pig;

import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.hadoop.BSONFileOutputFormat;
import com.mongodb.hadoop.pig.MongoStorage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.pig.LoadFunc;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.StoreFunc;
import org.apache.pig.StoreMetadata;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.impl.util.Utils;

public class BSONStorage
extends StoreFunc
implements StoreMetadata {
    private static final Log LOG = LogFactory.getLog(MongoStorage.class);
    static final String SCHEMA_SIGNATURE = "bson.pig.output.schema";
    protected ResourceSchema schema = null;
    private RecordWriter out;
    private String udfcSignature = null;
    private String idField = null;
    private final BSONFileOutputFormat outputFormat = new BSONFileOutputFormat();

    public BSONStorage() {
    }

    public BSONStorage(String idField) {
        this.idField = idField;
    }

    public static Object getTypeForBSON(Object o, ResourceSchema.ResourceFieldSchema field, String toIgnore) throws IOException {
        int dataType = field != null ? field.getType() : 0;
        ResourceSchema s = null;
        if (field == null) {
            dataType = o instanceof Map ? 100 : (o instanceof List ? 120 : 0);
        } else {
            s = field.getSchema();
            if (dataType == 0) {
                if (o instanceof Map) {
                    dataType = 100;
                }
                if (o instanceof List) {
                    dataType = 120;
                }
            }
        }
        if (dataType == 50 && o instanceof Map) {
            dataType = 100;
        }
        switch (dataType) {
            case 1: {
                return null;
            }
            case 10: 
            case 15: 
            case 20: 
            case 25: {
                return o;
            }
            case 50: {
                return o.toString();
            }
            case 55: {
                return o;
            }
            case 110: {
                if (s == null) {
                    throw new IOException("Schemas must be fully specified to use this storage function.  No schema found for field " + field.getName());
                }
                ResourceSchema.ResourceFieldSchema[] fs = s.getFields();
                LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
                for (int j = 0; j < fs.length; ++j) {
                    m.put(fs[j].getName(), BSONStorage.getTypeForBSON(((Tuple)o).get(j), fs[j], toIgnore));
                }
                return m;
            }
            case 120: {
                if (s == null) {
                    throw new IOException("Schemas must be fully specified to use this storage function.  No schema found for field " + field);
                }
                ResourceSchema.ResourceFieldSchema[] fs = s.getFields();
                if (fs.length != 1 || fs[0].getType() != 110) {
                    throw new IOException("Found a bag without a tuple inside!");
                }
                s = fs[0].getSchema();
                if (s == null) {
                    throw new IOException("Schemas must be fully specified to use this storage function.  No schema found for field " + field.getName());
                }
                fs = s.getFields();
                ArrayList<Object> a = new ArrayList<Object>();
                if (fs.length == 1 && fs[0].getName().equals(toIgnore)) {
                    for (Tuple t : (DataBag)o) {
                        a.add(t.get(0));
                    }
                } else {
                    for (Tuple t : (DataBag)o) {
                        LinkedHashMap<String, Object> ma = new LinkedHashMap<String, Object>();
                        for (int j = 0; j < fs.length; ++j) {
                            ma.put(fs[j].getName(), t.get(j));
                        }
                        a.add(ma);
                    }
                }
                return a;
            }
            case 100: {
                if (o == null) {
                    return null;
                }
                Map map = (Map)o;
                HashMap<String, Object> out = new HashMap<String, Object>(map.size());
                for (Object key : map.keySet()) {
                    out.put(key.toString(), BSONStorage.getTypeForBSON(map.get(key), null, toIgnore));
                }
                return out;
            }
        }
        return o;
    }

    protected void writeField(BasicDBObjectBuilder builder, ResourceSchema.ResourceFieldSchema field, Object d) throws IOException {
        String fieldName;
        Object convertedType = BSONStorage.getTypeForBSON(d, field, null);
        String string = fieldName = field != null ? field.getName() : "value";
        if (convertedType instanceof Map) {
            for (Map.Entry mapentry : ((Map)convertedType).entrySet()) {
                String addKey = ((String)mapentry.getKey()).equals(this.idField) ? "_id" : (String)mapentry.getKey();
                builder.add(addKey, mapentry.getValue());
            }
        } else {
            builder.add(fieldName, convertedType);
        }
    }

    public void checkSchema(ResourceSchema schema) throws IOException {
        this.schema = schema;
        UDFContext context = UDFContext.getUDFContext();
        Properties p = context.getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.udfcSignature});
        p.setProperty(SCHEMA_SIGNATURE, schema.toString());
    }

    public void storeSchema(ResourceSchema schema, String location, Job job) {
    }

    public void storeStatistics(ResourceStatistics stats, String location, Job job) {
    }

    public void putNext(Tuple tuple) throws IOException {
        try {
            BasicDBObjectBuilder builder = BasicDBObjectBuilder.start();
            ResourceSchema.ResourceFieldSchema[] fields = null;
            if (this.schema != null) {
                fields = this.schema.getFields();
            }
            if (fields != null) {
                for (int i = 0; i < fields.length; ++i) {
                    this.writeField(builder, fields[i], tuple.get(i));
                }
            } else {
                for (int i = 0; i < tuple.size(); ++i) {
                    this.writeField(builder, null, tuple.get(i));
                }
            }
            this.out.write(null, (Object)builder.get());
        }
        catch (Exception e) {
            throw new IOException("Couldn't convert tuple to bson: ", e);
        }
    }

    public void prepareToWrite(RecordWriter writer) throws IOException {
        this.out = writer;
        if (this.out == null) {
            throw new IOException("Invalid Record Writer");
        }
        UDFContext udfc = UDFContext.getUDFContext();
        Properties p = udfc.getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.udfcSignature});
        String strSchema = p.getProperty(SCHEMA_SIGNATURE);
        if (strSchema == null) {
            LOG.warn((Object)"Could not find schema in UDF context!");
            LOG.warn((Object)"Will attempt to write records without schema.");
        }
        try {
            this.schema = new ResourceSchema(Utils.getSchemaFromString((String)strSchema));
        }
        catch (Exception e) {
            this.schema = null;
            LOG.warn((Object)e.getMessage());
        }
    }

    public OutputFormat getOutputFormat() throws IOException {
        return this.outputFormat;
    }

    public String relToAbsPathForStoreLocation(String location, Path curDir) throws IOException {
        return LoadFunc.getAbsolutePath((String)location, (Path)curDir);
    }

    public void setStoreLocation(String location, Job job) throws IOException {
        Configuration config = job.getConfiguration();
        config.set("mapred.output.file", location);
    }

    public void setStoreFuncUDFContextSignature(String signature) {
        this.udfcSignature = signature;
    }
}

