/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.mapred.output;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.MongoException;
import com.mongodb.hadoop.MongoOutput;
import com.mongodb.hadoop.io.BSONWritable;
import com.mongodb.hadoop.io.MongoUpdateWritable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.bson.BSONObject;

public class MongoRecordWriter<K, V>
implements RecordWriter<K, V> {
    private int roundRobinCounter = 0;
    private final int numberOfHosts;
    private final List<DBCollection> collections;
    private final JobConf configuration;

    public MongoRecordWriter(List<DBCollection> c, JobConf conf) {
        this.collections = c;
        this.configuration = conf;
        this.numberOfHosts = c.size();
    }

    public void close(Reporter reporter) {
    }

    public void write(K key, V value) throws IOException {
        BasicDBObject o = new BasicDBObject();
        if (value instanceof MongoUpdateWritable) {
            MongoUpdateWritable muw = (MongoUpdateWritable)value;
            try {
                DBCollection dbCollection = this.getDbCollectionByRoundRobin();
                dbCollection.update(new BasicDBObject((Map)muw.getQuery()), new BasicDBObject((Map)muw.getModifiers()), muw.isUpsert(), muw.isMultiUpdate());
                return;
            }
            catch (MongoException e) {
                throw new IOException("can't write to mongo", e);
            }
        }
        if (key instanceof BSONWritable) {
            o.put("_id", (Object)((BSONWritable)key).getDoc());
        } else if (key instanceof BSONObject) {
            o.put("_id", key);
        } else {
            o.put("_id", BSONWritable.toBSON(key));
        }
        if (value instanceof BSONWritable) {
            o.putAll(((BSONWritable)value).getDoc());
        } else if (value instanceof MongoOutput) {
            ((MongoOutput)value).appendAsValue(o);
        } else if (value instanceof BSONObject) {
            o.putAll((BSONObject)value);
        } else {
            o.put("value", BSONWritable.toBSON(value));
        }
        try {
            DBCollection dbCollection = this.getDbCollectionByRoundRobin();
            dbCollection.save(o);
        }
        catch (MongoException e) {
            throw new IOException("can't write to mongo", e);
        }
    }

    private synchronized DBCollection getDbCollectionByRoundRobin() {
        int hostIndex = (this.roundRobinCounter++ & Integer.MAX_VALUE) % this.numberOfHosts;
        return this.collections.get(hostIndex);
    }

    public JobConf getConf() {
        return this.configuration;
    }
}

