/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.mapred.input;

import com.mongodb.hadoop.io.BSONWritable;
import com.mongodb.hadoop.util.MongoConfigUtil;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.RecordReader;
import org.bson.BSONCallback;
import org.bson.BSONDecoder;
import org.bson.BSONObject;
import org.bson.BasicBSONCallback;
import org.bson.BasicBSONDecoder;
import org.bson.LazyBSONCallback;
import org.bson.LazyBSONDecoder;

public class BSONFileRecordReader
implements RecordReader<NullWritable, BSONWritable> {
    private static final Log LOG = LogFactory.getLog(BSONFileRecordReader.class);
    private FileSplit fileSplit;
    private FSDataInputStream in;
    private int numDocsRead = 0;
    private boolean finished = false;
    private BSONCallback callback;
    private BSONDecoder decoder;

    public void initialize(InputSplit inputSplit, Configuration conf) throws IOException {
        this.fileSplit = (FileSplit)inputSplit;
        Path file = this.fileSplit.getPath();
        FileSystem fs = file.getFileSystem(conf);
        this.in = fs.open(file, 0x1000000);
        this.in.seek(this.fileSplit.getStart());
        if (MongoConfigUtil.getLazyBSON(conf)) {
            this.callback = new LazyBSONCallback();
            this.decoder = new LazyBSONDecoder();
        } else {
            this.callback = new BasicBSONCallback();
            this.decoder = new BasicBSONDecoder();
        }
    }

    public boolean next(NullWritable key, BSONWritable value) throws IOException {
        try {
            if (this.in.getPos() >= this.fileSplit.getStart() + this.fileSplit.getLength()) {
                try {
                    this.close();
                }
                catch (Exception e) {
                    LOG.warn((Object)e.getMessage(), (Throwable)e);
                }
                return false;
            }
            this.callback.reset();
            this.decoder.decode((InputStream)this.in, this.callback);
            BSONObject bo = (BSONObject)this.callback.get();
            value.setDoc(bo);
            ++this.numDocsRead;
            if (this.numDocsRead % 5000 == 0) {
                LOG.debug((Object)String.format("read %d docs from %s at %d", this.numDocsRead, this.fileSplit, this.in.getPos()));
            }
            return true;
        }
        catch (Exception e) {
            LOG.error((Object)String.format("Error reading key/value from bson file on line %d: %s", this.numDocsRead, e.getMessage()));
            try {
                this.close();
            }
            catch (Exception e2) {
                LOG.warn((Object)e2.getMessage(), (Throwable)e2);
            }
            return false;
        }
    }

    public float getProgress() throws IOException {
        if (this.finished) {
            return 1.0f;
        }
        if (this.in != null) {
            return (float)(this.in.getPos() - this.fileSplit.getStart()) / (float)this.fileSplit.getLength();
        }
        return 0.0f;
    }

    public long getPos() throws IOException {
        if (this.finished) {
            return this.fileSplit.getStart() + this.fileSplit.getLength();
        }
        if (this.in != null) {
            return this.in.getPos();
        }
        return this.fileSplit.getStart();
    }

    public NullWritable createKey() {
        return NullWritable.get();
    }

    public BSONWritable createValue() {
        return new BSONWritable();
    }

    public void close() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"closing bson file split.");
        }
        this.finished = true;
        if (this.in != null) {
            this.in.close();
        }
    }
}

