/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.mapred;

import com.mongodb.hadoop.mapred.output.BSONFileRecordWriter;
import com.mongodb.hadoop.splitter.BSONSplitter;
import com.mongodb.hadoop.util.MongoConfigUtil;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.util.Progressable;

public class BSONFileOutputFormat<K, V>
extends FileOutputFormat<K, V> {
    private static final Log LOG = LogFactory.getLog(BSONFileOutputFormat.class);

    public RecordWriter<K, V> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        Path outPath = BSONFileOutputFormat.getDefaultWorkFile(job, name, ".bson");
        LOG.info((Object)("output going into " + outPath));
        FileSystem fs = outPath.getFileSystem((Configuration)job);
        FSDataOutputStream outFile = fs.create(outPath);
        FSDataOutputStream splitFile = null;
        if (MongoConfigUtil.getBSONOutputBuildSplits((Configuration)job)) {
            Path splitPath = new Path(outPath.getParent(), "." + outPath.getName() + ".splits");
            splitFile = fs.create(splitPath);
        }
        long splitSize = BSONSplitter.getSplitSize((Configuration)job, null);
        return new BSONFileRecordWriter(outFile, splitFile, splitSize);
    }

    public static Path getDefaultWorkFile(JobConf conf, String name, String extension) {
        return new Path(BSONFileOutputFormat.getWorkOutputPath((JobConf)conf), BSONFileOutputFormat.getUniqueName((JobConf)conf, (String)name) + extension);
    }
}

