/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop.io;

import com.mongodb.BasicDBObject;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Writable;
import org.bson.BSONCallback;
import org.bson.BSONEncoder;
import org.bson.BSONObject;
import org.bson.BasicBSONCallback;
import org.bson.BasicBSONDecoder;
import org.bson.BasicBSONEncoder;
import org.bson.BasicBSONObject;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.Bits;

public class MongoUpdateWritable
implements Writable {
    private static final Log LOG = LogFactory.getLog(MongoUpdateWritable.class);
    private BasicBSONObject query;
    private BasicBSONObject modifiers;
    private boolean upsert;
    private boolean multiUpdate;
    private BSONEncoder enc = new BasicBSONEncoder();
    private BasicOutputBuffer buf = new BasicOutputBuffer();
    protected BSONObject _doc;

    public MongoUpdateWritable(BasicBSONObject query, BasicBSONObject modifiers, boolean upsert, boolean multiUpdate) {
        this.query = query;
        this.modifiers = modifiers;
        this.upsert = upsert;
        this.multiUpdate = multiUpdate;
    }

    public MongoUpdateWritable(BasicBSONObject query, BasicBSONObject modifiers) {
        this(query, modifiers, true, false);
    }

    public BasicBSONObject getQuery() {
        return this.query;
    }

    public BasicBSONObject getModifiers() {
        return this.modifiers;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    public boolean isMultiUpdate() {
        return this.multiUpdate;
    }

    public void write(DataOutput out) throws IOException {
        this.enc.set(this.buf);
        this.enc.putObject(this.query);
        this.enc.done();
        this.buf.pipe(out);
        this.enc.set(this.buf);
        this.enc.putObject(this.modifiers);
        this.enc.done();
        out.writeBoolean(this.upsert);
        out.writeBoolean(this.multiUpdate);
    }

    public void readFields(DataInput in) throws IOException {
        BasicBSONDecoder dec = new BasicBSONDecoder();
        BasicBSONCallback cb = new BasicBSONCallback();
        byte[] l = new byte[4];
        try {
            in.readFully(l);
            int dataLen = Bits.readInt(l);
            byte[] data = new byte[dataLen + 4];
            System.arraycopy(l, 0, data, 0, 4);
            in.readFully(data, 4, dataLen - 4);
            dec.decode(data, (BSONCallback)cb);
            this.query = (BasicBSONObject)cb.get();
            in.readFully(l);
            dataLen = Bits.readInt(l);
            data = new byte[dataLen + 4];
            System.arraycopy(l, 0, data, 0, 4);
            in.readFully(data, 4, dataLen - 4);
            dec.decode(data, (BSONCallback)cb);
            this.modifiers = (BasicBSONObject)cb.get();
            this.upsert = in.readBoolean();
            this.multiUpdate = in.readBoolean();
        }
        catch (Exception e) {
            LOG.info((Object)("No Length Header available." + e));
            this.query = new BasicDBObject();
            this.modifiers = new BasicDBObject();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MongoUpdateWritable other = (MongoUpdateWritable)obj;
        if (this.upsert != other.upsert || this.multiUpdate != other.multiUpdate) {
            return false;
        }
        if (this.query == other.query || this.query != null && this.query.equals(other.query)) {
            return true;
        }
        return this.modifiers == other.modifiers || this.modifiers != null && this.modifiers.equals(other.modifiers);
    }

    public int hashCode() {
        int hashCode = this.query.hashCode();
        hashCode ^= this.modifiers.hashCode();
        hashCode ^= (this.upsert ? 1 : 0) << 1;
        return hashCode ^= (this.multiUpdate ? 1 : 0) << 2;
    }
}

