/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.hadoop;

import com.mongodb.hadoop.output.BSONFileRecordWriter;
import com.mongodb.hadoop.splitter.BSONSplitter;
import com.mongodb.hadoop.util.MongoConfigUtil;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class BSONFileOutputFormat<K, V>
extends FileOutputFormat<K, V> {
    private static final Log LOG = LogFactory.getLog(BSONFileOutputFormat.class);

    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext context) throws IOException {
        Path outPath = this.getDefaultWorkFile(context, ".bson");
        LOG.info((Object)("output going into " + outPath));
        FileSystem fs = outPath.getFileSystem(context.getConfiguration());
        FSDataOutputStream outFile = fs.create(outPath);
        FSDataOutputStream splitFile = null;
        if (MongoConfigUtil.getBSONOutputBuildSplits(context.getConfiguration())) {
            Path splitPath = new Path(outPath.getParent(), "." + outPath.getName() + ".splits");
            splitFile = fs.create(splitPath);
        }
        long splitSize = BSONSplitter.getSplitSize(context.getConfiguration(), null);
        return new BSONFileRecordWriter(outFile, splitFile, splitSize);
    }
}

