/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.bson.assertions.Assertions;
import org.bson.codecs.pojo.ClassModelBuilder;
import org.bson.codecs.pojo.FieldAccessorImpl;
import org.bson.codecs.pojo.FieldModel;
import org.bson.codecs.pojo.FieldModelBuilder;
import org.bson.codecs.pojo.FieldModelSerializationImpl;
import org.bson.codecs.pojo.InstanceCreatorFactoryImpl;
import org.bson.codecs.pojo.TypeData;
import org.bson.codecs.pojo.TypeParameterMap;

final class PojoBuilderHelper {
    static <T> void configureClassModelBuilder(ClassModelBuilder<T> classModelBuilder, Class<T> clazz) {
        classModelBuilder.type(Assertions.notNull("clazz", clazz));
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        HashSet<String> fieldNames = new HashSet<String>();
        HashMap<String, TypeParameterMap> fieldTypeParameterMap = new HashMap<String, TypeParameterMap>();
        Class<T> currentClass = clazz;
        TypeData<T> parentClassTypeData = null;
        while (currentClass.getSuperclass() != null) {
            annotations.addAll(Arrays.asList(currentClass.getDeclaredAnnotations()));
            ArrayList<String> genericTypeNames = new ArrayList<String>();
            for (AnnotatedElement annotatedElement : currentClass.getTypeParameters()) {
                genericTypeNames.add(annotatedElement.getName());
            }
            for (AnnotatedElement annotatedElement : currentClass.getDeclaredFields()) {
                if (!fieldNames.add(((Field)annotatedElement).getName()) || Modifier.isTransient(((Field)annotatedElement).getModifiers()) || Modifier.isStatic(((Field)annotatedElement).getModifiers())) continue;
                TypeParameterMap typeParameterMap = PojoBuilderHelper.getTypeParameterMap(genericTypeNames, (Field)annotatedElement);
                fieldTypeParameterMap.put(((Field)annotatedElement).getName(), typeParameterMap);
                FieldModelBuilder<?> fieldModelBuilder = PojoBuilderHelper.getFieldBuilder((Field)annotatedElement, ((Field)annotatedElement).getType());
                if (parentClassTypeData != null) {
                    PojoBuilderHelper.specializeFieldModelBuilder(fieldModelBuilder, typeParameterMap, parentClassTypeData.getTypeParameters());
                }
                classModelBuilder.addField(fieldModelBuilder);
                ((Field)annotatedElement).setAccessible(true);
            }
            parentClassTypeData = PojoBuilderHelper.getTypeData(currentClass.getGenericSuperclass(), currentClass);
            currentClass = currentClass.getSuperclass();
        }
        Collections.reverse(annotations);
        classModelBuilder.annotations(annotations);
        classModelBuilder.fieldNameToTypeParameterMap(fieldTypeParameterMap);
        AnnotatedElement noArgsConstructor = null;
        for (AnnotatedElement annotatedElement : clazz.getDeclaredConstructors()) {
            if (((Constructor)annotatedElement).getParameterTypes().length != 0) continue;
            noArgsConstructor = annotatedElement;
            ((Constructor)noArgsConstructor).setAccessible(true);
        }
        classModelBuilder.instanceCreatorFactory(new InstanceCreatorFactoryImpl(clazz.getSimpleName(), noArgsConstructor));
    }

    private static <T> TypeData<T> getTypeData(Type genericType, Class<T> clazz) {
        TypeData.Builder<T> builder = TypeData.builder(clazz);
        if (genericType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)genericType;
            for (Type argType : pType.getActualTypeArguments()) {
                PojoBuilderHelper.getNestedTypeData(builder, argType);
            }
        }
        return builder.build();
    }

    private static <T> void getNestedTypeData(TypeData.Builder<T> builder, Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            TypeData.Builder paramBuilder = TypeData.builder((Class)pType.getRawType());
            for (Type argType : pType.getActualTypeArguments()) {
                PojoBuilderHelper.getNestedTypeData(paramBuilder, argType);
            }
            builder.addTypeParameter(paramBuilder.build());
        } else if (type instanceof TypeVariable) {
            builder.addTypeParameter(TypeData.builder(Object.class).build());
        } else if (type instanceof Class) {
            builder.addTypeParameter(TypeData.builder((Class)type).build());
        }
    }

    private static <T> FieldModelBuilder<T> getFieldBuilder(Field field, Class<T> clazz) {
        return FieldModel.builder(field);
    }

    static <T> FieldModelBuilder<T> configureFieldModelBuilder(FieldModelBuilder<T> builder, Field field) {
        return builder.fieldName(field.getName()).documentFieldName(field.getName()).typeData(PojoBuilderHelper.getTypeData(field.getGenericType(), field.getType())).annotations(Arrays.asList(field.getDeclaredAnnotations())).fieldSerialization(new FieldModelSerializationImpl()).fieldAccessor(new FieldAccessorImpl(field, field.getName()));
    }

    private static TypeParameterMap getTypeParameterMap(List<String> genericTypeNames, Field field) {
        int classParamIndex = genericTypeNames.indexOf(field.getGenericType().toString());
        TypeParameterMap.Builder builder = TypeParameterMap.builder();
        if (classParamIndex != -1) {
            builder.addIndex(classParamIndex);
        } else {
            Type type = field.getGenericType();
            if (type instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)type;
                for (int i = 0; i < pt.getActualTypeArguments().length; ++i) {
                    classParamIndex = genericTypeNames.indexOf(pt.getActualTypeArguments()[i].toString());
                    if (classParamIndex == -1) continue;
                    builder.addIndex(i, classParamIndex);
                }
            }
        }
        return builder.build();
    }

    private static <V> void specializeFieldModelBuilder(FieldModelBuilder<V> fieldModelBuilder, TypeParameterMap typeParameterMap, List<TypeData<?>> fieldTypeParameters) {
        if (typeParameterMap.hasTypeParameters() && !fieldTypeParameters.isEmpty()) {
            TypeData<Object> specializedFieldType = fieldModelBuilder.getTypeData();
            Map<Integer, Integer> fieldToClassParamIndexMap = typeParameterMap.getFieldToClassParamIndexMap();
            Integer classTypeParamRepresentsWholeField = fieldToClassParamIndexMap.get(-1);
            if (classTypeParamRepresentsWholeField != null) {
                specializedFieldType = fieldTypeParameters.get(classTypeParamRepresentsWholeField);
            } else {
                TypeData.Builder<V> builder = TypeData.builder(fieldModelBuilder.getTypeData().getType());
                ArrayList typeParameters = new ArrayList(fieldModelBuilder.getTypeData().getTypeParameters());
                for (int i = 0; i < typeParameters.size(); ++i) {
                    for (Map.Entry<Integer, Integer> mapping : fieldToClassParamIndexMap.entrySet()) {
                        if (!mapping.getKey().equals(i)) continue;
                        typeParameters.set(i, fieldTypeParameters.get(mapping.getValue()));
                    }
                }
                builder.addTypeParameters(typeParameters);
                specializedFieldType = builder.build();
            }
            fieldModelBuilder.typeData(specializedFieldType);
        }
    }

    static <V> V stateNotNull(String property, V value) {
        if (value == null) {
            throw new IllegalStateException(String.format("%s cannot be null", property));
        }
        return value;
    }

    private PojoBuilderHelper() {
    }
}

