/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.lang.reflect.Field;
import org.bson.codecs.Codec;
import org.bson.codecs.pojo.FieldAccessor;
import org.bson.codecs.pojo.FieldModelBuilder;
import org.bson.codecs.pojo.FieldSerialization;
import org.bson.codecs.pojo.TypeData;

public final class FieldModel<T> {
    private final String fieldName;
    private final String documentFieldName;
    private final TypeData<T> typeData;
    private final Codec<T> codec;
    private final FieldSerialization<T> fieldSerialization;
    private final Boolean useDiscriminator;
    private final FieldAccessor<T> fieldAccessor;
    private volatile Codec<T> cachedCodec;

    FieldModel(String fieldName, String documentFieldName, TypeData<T> typeData, Codec<T> codec, FieldSerialization<T> fieldSerialization, Boolean useDiscriminator, FieldAccessor<T> fieldAccessor) {
        this.fieldName = fieldName;
        this.documentFieldName = documentFieldName;
        this.typeData = typeData;
        this.codec = codec;
        this.cachedCodec = codec;
        this.fieldSerialization = fieldSerialization;
        this.useDiscriminator = useDiscriminator;
        this.fieldAccessor = fieldAccessor;
    }

    static <S> FieldModelBuilder<S> builder(Field field) {
        return new FieldModelBuilder(field);
    }

    public boolean shouldSerialize(T value) {
        return this.fieldSerialization.shouldSerialize(value);
    }

    public FieldAccessor<T> getFieldAccessor() {
        return this.fieldAccessor;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getDocumentFieldName() {
        return this.documentFieldName;
    }

    public TypeData<T> getTypeData() {
        return this.typeData;
    }

    public Codec<T> getCodec() {
        return this.codec;
    }

    public Boolean useDiscriminator() {
        return this.useDiscriminator;
    }

    public String toString() {
        return "FieldModel{fieldName='" + this.fieldName + "', documentFieldName='" + this.documentFieldName + "', typeData=" + this.typeData + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldModel)) {
            return false;
        }
        FieldModel that = (FieldModel)o;
        if (this.useDiscriminator() != null ? !this.useDiscriminator().equals(that.useDiscriminator()) : that.useDiscriminator() != null) {
            return false;
        }
        if (this.getFieldName() != null ? !this.getFieldName().equals(that.getFieldName()) : that.getFieldName() != null) {
            return false;
        }
        if (this.getDocumentFieldName() != null ? !this.getDocumentFieldName().equals(that.getDocumentFieldName()) : that.getDocumentFieldName() != null) {
            return false;
        }
        if (this.getTypeData() != null ? !this.getTypeData().equals(that.getTypeData()) : that.getTypeData() != null) {
            return false;
        }
        if (this.getCodec() != null ? !this.getCodec().equals(that.getCodec()) : that.getCodec() != null) {
            return false;
        }
        if (this.getFieldSerialization() != null ? !this.getFieldSerialization().equals(that.getFieldSerialization()) : that.getFieldSerialization() != null) {
            return false;
        }
        return !(this.getFieldAccessor() != null ? !this.getFieldAccessor().equals(that.getFieldAccessor()) : that.getFieldAccessor() != null);
    }

    public int hashCode() {
        int result = this.getFieldName() != null ? this.getFieldName().hashCode() : 0;
        result = 31 * result + (this.getDocumentFieldName() != null ? this.getDocumentFieldName().hashCode() : 0);
        result = 31 * result + (this.getTypeData() != null ? this.getTypeData().hashCode() : 0);
        result = 31 * result + (this.getCodec() != null ? this.getCodec().hashCode() : 0);
        result = 31 * result + (this.getFieldSerialization() != null ? this.getFieldSerialization().hashCode() : 0);
        result = 31 * result + (this.useDiscriminator != null ? this.useDiscriminator.hashCode() : 0);
        result = 31 * result + (this.getFieldAccessor() != null ? this.getFieldAccessor().hashCode() : 0);
        return result;
    }

    FieldSerialization<T> getFieldSerialization() {
        return this.fieldSerialization;
    }

    void cachedCodec(Codec<T> codec) {
        this.cachedCodec = codec;
    }

    Codec<T> getCachedCodec() {
        return this.cachedCodec;
    }
}

